/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.apply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.FinBizStatusEnum;
import kd.tmc.cim.common.enums.SchemeBizStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinApplyAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("finservicestatus");
        selector.add("entry");
        selector.add("e_productno");
        selector.add("e_isselect");
        selector.add("inquiry");
        selector.add("productno");
        selector.add("productname");
        selector.add("investvarieties");
        selector.add("productfactory");
        selector.add("finorginfo");
        selector.add("finaccount");
        selector.add("finaccountf7");
        selector.add("settleaccount");
        selector.add("valuedate");
        selector.add("expiredate");
        selector.add("term");
        selector.add("redeemway");
        selector.add("amount");
        selector.add("buycopies");
        selector.add("iopv");
        selector.add("revenuetype");
        selector.add("planrevenue");
        selector.add("floatplanrevenue");
        selector.add("basis");
        selector.add("planamount");
        selector.add("intdate");
        selector.add("redeempatternstr");
        selector.add("redeempattern");
        selector.add("bonusway");
        selector.add("revenueproject");
        selector.add("risklevel");
        selector.add("explain");
        selector.add("e_schemeid");
        selector.add("lastamount");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> abandonSchemeIds = new ArrayList<Long>();
        ArrayList<Long> acceptSchemeIds = new ArrayList<Long>();
        for (DynamicObject finApply : dataEntities) {
            finApply.set("finservicestatus", (Object)FinBizStatusEnum.UNHANDLE.getValue());
            DynamicObjectCollection entrys = finApply.getDynamicObjectCollection("entry");
            if (CollectionUtils.isEmpty((Collection)entrys)) continue;
            for (DynamicObject row : entrys) {
                Long productno = row.getLong("e_schemeid");
                if (row.getBoolean("e_isselect")) {
                    acceptSchemeIds.add(productno);
                    continue;
                }
                abandonSchemeIds.add(productno);
            }
        }
        DynamicObject[] finSchemes = TmcDataServiceHelper.load((Object[])Stream.concat(abandonSchemeIds.stream(), acceptSchemeIds.stream()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_finscheme"));
        this.syncSchemeInfo(dataEntities, finSchemes);
        this.syncSchemeStatus(abandonSchemeIds, finSchemes);
    }

    private void syncSchemeInfo(DynamicObject[] dataEntities, DynamicObject[] finSchemes) {
        Map<Long, DynamicObject> schemeMap = Arrays.stream(finSchemes).collect(Collectors.toMap(v -> v.getLong("id"), o -> o));
        for (DynamicObject finApply : dataEntities) {
            DynamicObject selectScheme;
            DynamicObjectCollection schemeEntry;
            DynamicObject selectEntry;
            if (!finApply.getBoolean("inquiry") || EmptyUtil.isEmpty((DynamicObject)(selectEntry = (schemeEntry = finApply.getDynamicObjectCollection("entry")).stream().filter(v -> v.getBoolean("e_isselect")).findFirst().orElseGet(null))) || EmptyUtil.isEmpty((DynamicObject)(selectScheme = schemeMap.get(selectEntry.getLong("e_schemeid"))))) continue;
            finApply.set("product", (Object)selectScheme.getDynamicObject("product"));
            finApply.set("productno", (Object)selectScheme.getString("productno"));
            finApply.set("productname", (Object)selectScheme.getString("name"));
            finApply.set("investvarieties", (Object)selectScheme.getDynamicObject("investvarieties"));
            finApply.set("productfactory", (Object)selectScheme.getDynamicObject("productfactory"));
            finApply.set("finorginfo", (Object)selectScheme.getDynamicObject("finorginfo"));
            finApply.set("finaccount", (Object)selectScheme.getString("finaccount"));
            finApply.set("finaccountf7", (Object)selectScheme.getDynamicObject("finaccountf7"));
            finApply.set("settleaccount", (Object)selectScheme.getDynamicObject("settleaccount"));
            finApply.set("valuedate", (Object)selectScheme.getDate("valuedate"));
            finApply.set("expiredate", (Object)selectScheme.getDate("expiredate"));
            finApply.set("term", (Object)selectScheme.getString("term"));
            finApply.set("redeemway", (Object)selectScheme.getString("redeemway"));
            finApply.set("amount", (Object)selectScheme.getBigDecimal("amount"));
            finApply.set("buycopies", selectScheme.get("buycopies"));
            finApply.set("iopv", (Object)selectScheme.getBigDecimal("iopv"));
            finApply.set("revenuetype", (Object)selectScheme.getString("revenuetype"));
            finApply.set("planrevenue", selectScheme.get("planrevenue"));
            finApply.set("floatplanrevenue", selectScheme.get("floatplanrevenue"));
            finApply.set("basis", (Object)selectScheme.getString("basis"));
            finApply.set("planamount", (Object)selectScheme.getBigDecimal("planamount"));
            finApply.set("intdate", (Object)selectScheme.getDate("intdate"));
            finApply.set("redeempatternstr", (Object)selectScheme.getString("redeempatternstr"));
            finApply.set("redeempattern", selectScheme.get("redeempattern"));
            finApply.set("bonusway", (Object)selectScheme.getString("bonusway"));
            finApply.set("revenueproject", (Object)selectScheme.getDynamicObject("revenueproject"));
            finApply.set("risklevel", (Object)selectScheme.getString("risklevel"));
            finApply.set("explain", (Object)selectScheme.getString("comment"));
            finApply.set("lastamount", (Object)selectScheme.getBigDecimal("amount"));
        }
    }

    private void syncSchemeStatus(List<Long> abandonSchemeIds, DynamicObject[] finSchemes) {
        for (DynamicObject finScheme : finSchemes) {
            finScheme.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            if (abandonSchemeIds.contains(finScheme.getLong("id"))) {
                finScheme.set("bizstatus", (Object)SchemeBizStatusEnum.ABANDON.getValue());
                continue;
            }
            finScheme.set("bizstatus", (Object)SchemeBizStatusEnum.ACCEPT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])finSchemes);
    }
}

