/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.apply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.FinApplyTypeEnum;
import kd.tmc.cim.common.enums.FinBizStatusEnum;
import kd.tmc.cim.common.enums.SchemeBizStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinApplyUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("relatescheme");
        selector.add("entry");
        selector.add("e_isselect");
        selector.add("e_productno");
        selector.add("finservicestatus");
        selector.add("productno");
        selector.add("inquiry");
        selector.add("productname");
        selector.add("investvarieties");
        selector.add("productfactory");
        selector.add("finorginfo");
        selector.add("finaccount");
        selector.add("finaccountf7");
        selector.add("settleaccount");
        selector.add("valuedate");
        selector.add("expiredate");
        selector.add("term");
        selector.add("redeemway");
        selector.add("amount");
        selector.add("buycopies");
        selector.add("iopv");
        selector.add("revenuetype");
        selector.add("planrevenue");
        selector.add("floatplanrevenue");
        selector.add("basis");
        selector.add("planamount");
        selector.add("intdate");
        selector.add("redeempattern");
        selector.add("redeempatternstr");
        selector.add("bonusway");
        selector.add("revenueproject");
        selector.add("risklevel");
        selector.add("explain");
        selector.add("e_schemeid");
        selector.add("applytype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> schemeIds = new ArrayList<Long>(16);
        for (DynamicObject finApply : dataEntities) {
            finApply.set("relatescheme", (Object)false);
            finApply.set("finservicestatus", (Object)FinBizStatusEnum.APPLYING.getValue());
            DynamicObjectCollection entrys = finApply.getDynamicObjectCollection("entry");
            entrys.stream().forEach(v -> v.set("e_isselect", (Object)false));
            schemeIds.addAll(entrys.stream().map(v -> v.getLong("e_schemeid")).collect(Collectors.toList()));
            if (!finApply.getBoolean("inquiry")) continue;
            this.clearSchemeInfo(finApply);
        }
        this.deleteFinSubscribe(Arrays.asList(dataEntities).stream().filter(o -> FinApplyTypeEnum.PURCHASE.getValue().equals(o.get("applytype"))).collect(Collectors.toList()));
        this.deleteRedeem(Arrays.asList(dataEntities).stream().filter(o -> FinApplyTypeEnum.REDEEM.getValue().equals(o.get("applytype"))).collect(Collectors.toList()));
        if (EmptyUtil.isNoEmpty(schemeIds)) {
            this.syncSchemeStatus(schemeIds);
        }
    }

    private void syncSchemeStatus(List<Long> schemeIds) {
        DynamicObject[] finSchemes;
        for (DynamicObject finScheme : finSchemes = TmcDataServiceHelper.load((String)"cim_finscheme", (String)"bizstatus,status", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)})) {
            finScheme.set("bizstatus", (Object)SchemeBizStatusEnum.UNDETERMINED.getValue());
            finScheme.set("status", (Object)BillStatusEnum.SAVE.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])finSchemes);
    }

    private void deleteFinSubscribe(List<DynamicObject> dataEntities) {
        ArrayList<Object> finSubscribeIds = new ArrayList<Object>(dataEntities.size());
        for (DynamicObject finapply : dataEntities) {
            Object[] finsubscribeId = TmcBotpHelper.getTargetBillIds((String)"cim_finapply", (Object)finapply.getPkValue(), (String)"cim_finsubscribe");
            if (!EmptyUtil.isNoEmpty((Object[])finsubscribeId)) continue;
            finSubscribeIds.addAll(Arrays.asList(finsubscribeId));
        }
        if (EmptyUtil.isNoEmpty(finSubscribeIds)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cim_finsubscribe", (Object[])finSubscribeIds.toArray(), (OperateOption)OperateOption.create());
        }
    }

    private void deleteRedeem(List<DynamicObject> dataEntities) {
        ArrayList<Object> redeemIds = new ArrayList<Object>(dataEntities.size());
        for (DynamicObject finapply : dataEntities) {
            Object[] redeemId = TmcBotpHelper.getTargetBillIds((String)"cim_finapply", (Object)finapply.getPkValue(), (String)"cim_redeem");
            if (!EmptyUtil.isNoEmpty((Object[])redeemId)) continue;
            redeemIds.addAll(Arrays.asList(redeemId));
        }
        if (EmptyUtil.isNoEmpty(redeemIds)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cim_redeem", (Object[])redeemIds.toArray(), (OperateOption)OperateOption.create());
        }
    }

    private void clearSchemeInfo(DynamicObject finApply) {
        finApply.set("productno", (Object)"");
        finApply.set("productname", (Object)"");
        finApply.set("investvarieties", (Object)0L);
        finApply.set("productfactory", (Object)0L);
        finApply.set("finorginfo", (Object)0L);
        finApply.set("finaccount", (Object)"");
        finApply.set("finaccountf7", (Object)0L);
        finApply.set("settleaccount", (Object)0L);
        finApply.set("valuedate", null);
        finApply.set("expiredate", null);
        finApply.set("term", (Object)"");
        finApply.set("redeemway", (Object)"");
        finApply.set("amount", (Object)0);
        finApply.set("buycopies", (Object)0);
        finApply.set("iopv", (Object)0);
        finApply.set("revenuetype", (Object)"");
        finApply.set("planrevenue", (Object)0);
        finApply.set("floatplanrevenue", (Object)0);
        finApply.set("basis", (Object)"");
        finApply.set("planamount", (Object)0);
        finApply.set("intdate", null);
        finApply.set("redeempattern", (Object)0);
        finApply.set("redeempatternstr", (Object)"");
        finApply.set("bonusway", (Object)"");
        finApply.set("revenueproject", (Object)0L);
        finApply.set("risklevel", (Object)"");
        finApply.set("explain", (Object)"");
    }
}

