/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractReDepositService
extends AbstractTmcBizOppService {
    private List<Object> reDepositBills = new ArrayList<Object>();

    public void process(DynamicObject[] dataEntities) throws KDException {
        Object[] billIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)dataEntities[0].getDynamicObjectType().getName());
        DynamicObject[] depositBills = TmcDataServiceHelper.load((Object[])billIds, (DynamicObjectType)entityType);
        ArrayList<DynamicObject> newDepositBills = new ArrayList<DynamicObject>(depositBills.length);
        for (DynamicObject depositBill : depositBills) {
            DynamicObject newDepositBill = TmcDataServiceHelper.clone((DynamicObject)depositBill);
            this.setRedepositBillValues(newDepositBill, depositBill);
            newDepositBills.add(newDepositBill);
        }
        String operateByUser = (String)this.getOperationVariable().get("OPERATE_BY_USER");
        List validateErrors = this.getOperationResult().getValidateResult().getValidateErrors();
        if (dataEntities.length == 1 && EmptyUtil.isEmpty((Collection)validateErrors) && EmptyUtil.isNoEmpty((String)operateByUser)) {
            this.reDepositBills.add(DynamicObjectSerializeUtil.serialize((Object[])newDepositBills.toArray(), (DynamicObjectType)entityType));
            return;
        }
        this.saveRedepositBill(newDepositBills);
    }

    private void saveRedepositBill(List<DynamicObject> newDepositBills) {
        if (EmptyUtil.isNoEmpty(newDepositBills)) {
            Map opMap = this.getOperationVariable();
            String entityName = newDepositBills.get(0).getDataEntityType().getName();
            OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)entityName, (DynamicObject[])newDepositBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create(), (boolean)true);
            List redepositIds = saveResult.getSuccessPkIds();
            if (!opMap.containsKey("OPERATE_BY_USER")) {
                OperationResult submitResult;
                String revenueBillStatus = BillStatusEnum.SAVE.getValue();
                String billstatusParam = (String)opMap.get("billstatus_param");
                if (EmptyUtil.isNoEmpty((String)billstatusParam)) {
                    revenueBillStatus = billstatusParam;
                }
                if (BillStatusEnum.SAVE.getValue().equals(revenueBillStatus) || EmptyUtil.isEmpty((Collection)redepositIds)) {
                    return;
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("WF", "TRUE");
                try (TXHandle txHandle = TX.requiresNew((String)"cim_deposit_redeposit");){
                    submitResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"submit", (String)entityName, (Object[])redepositIds.toArray(), (OperateOption)option);
                }
                if (BillStatusEnum.AUDIT.getValue().equals(revenueBillStatus) && EmptyUtil.isNoEmpty((Object)submitResult) && submitResult.isSuccess()) {
                    TmcOperateServiceHelper.execOperateWithoutThrow((String)"audit", (String)entityName, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
                }
                this.handleRollBack(redepositIds, entityName, revenueBillStatus);
            }
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (this.getOperationResult().isSuccess() && EmptyUtil.isNoEmpty(this.reDepositBills)) {
            e.setSuccessPkIds(this.reDepositBills);
        }
    }

    private void setRedepositBillValues(DynamicObject newDepositBill, DynamicObject depositBill) {
        this.setExtValue(newDepositBill, depositBill);
        String entityName = newDepositBill.getDynamicObjectType().getName();
        String orgId = String.valueOf(newDepositBill.getDynamicObject("org").getPkValue());
        newDepositBill.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)entityName, (DynamicObject)newDepositBill, (String)orgId));
        newDepositBill.set("bizdate", (Object)DateUtils.truncateDate((Date)new Date()));
        newDepositBill.set("isredepositgenerate", (Object)Boolean.TRUE);
        newDepositBill.set("srcdepositno", (Object)depositBill.getString("billno"));
        newDepositBill.set("srcdepositid", depositBill.getPkValue());
        newDepositBill.set("lastredeemdate", null);
        newDepositBill.set("lastrevenuedate", null);
        newDepositBill.set("endpreinstdate", null);
        newDepositBill.set("apply", null);
        newDepositBill.set("sourcebillid", null);
        newDepositBill.set("sourcebilltype", null);
        newDepositBill.set("bankcheckflag", null);
        newDepositBill.set("bebankstatus", null);
        newDepositBill.set("isresubmit", null);
        newDepositBill.set("submittime", null);
        newDepositBill.set("returnmsg", null);
        newDepositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_ing.getValue());
        newDepositBill.set("redeemamount", null);
        newDepositBill.set("surplusamount", (Object)newDepositBill.getBigDecimal("amount"));
        newDepositBill.set("totalamount", null);
        newDepositBill.set("eassrcid", null);
        newDepositBill.set("isinit", null);
        newDepositBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        newDepositBill.set("createtime", (Object)new Date());
        newDepositBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        BigDecimal surplusAmt = depositBill.getBigDecimal("surplusamount");
        newDepositBill.set("srcprincipal", (Object)surplusAmt);
    }

    private void handleRollBack(List<Object> ids, String entityName, String billstatus) {
        QFilter filter = new QFilter("id", "in", ids);
        if (BillStatusEnum.isSubmit((String)billstatus)) {
            filter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        } else if (BillStatusEnum.isAudit((String)billstatus)) {
            filter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        }
        DynamicObjectCollection depositBills = QueryServiceHelper.query((String)entityName, (String)"id,billstatus", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)depositBills)) {
            Object[] releaseIds;
            Object[] submitIds = depositBills.stream().filter(v -> BillStatusEnum.isSubmit((String)v.getString("billstatus"))).map(r -> r.get("id")).toArray();
            if (EmptyUtil.isNoEmpty((Object[])submitIds)) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])submitIds, (OperateOption)OperateOption.create(), (boolean)true);
            }
            if (EmptyUtil.isNoEmpty((Object[])(releaseIds = depositBills.stream().map(r -> r.get("id")).toArray()))) {
                TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])submitIds, (OperateOption)OperateOption.create(), (boolean)true);
            }
        }
    }

    abstract void setExtValue(DynamicObject var1, DynamicObject var2);
}

