/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.AgreeDepositStatusEnum;
import kd.tmc.cim.common.enums.DepositApplyStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AgreeDepositDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("isredepositgenerate");
        selector.add("srcdepositno");
        selector.add("apply");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List srcBillIdList;
        List srcBillList = Arrays.stream(dataEntities).filter(r -> r.getBoolean("isredepositgenerate")).map(r -> r.getString("srcdepositno")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(srcBillList)) {
            DynamicObject[] srcDeposits;
            for (DynamicObject srcDeposit : srcDeposits = TmcDataServiceHelper.load((String)"cim_agreement_deposit", (String)"status", (QFilter[])new QFilter[]{new QFilter("billno", "in", srcBillList)})) {
                srcDeposit.set("status", (Object)AgreeDepositStatusEnum.NORMAL.getValue());
            }
            SaveServiceHelper.update((DynamicObject[])srcDeposits);
        }
        if (EmptyUtil.isNoEmpty(srcBillIdList = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((DynamicObject)r.getDynamicObject("apply"))).map(r -> r.getDynamicObject("apply")).map(DataEntityBase::getPkValue).collect(Collectors.toList()))) {
            Object[] srcBills = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"applystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIdList)});
            if (EmptyUtil.isEmpty((Object[])srcBills)) {
                return;
            }
            for (Object srcBill : srcBills) {
                srcBill.set("applystatus", (Object)DepositApplyStatusEnum.UNHANDLE.getValue());
            }
            SaveServiceHelper.update((DynamicObject[])srcBills);
        }
    }
}

