/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.SchemeBizStatusEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class DepositApplyUnSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("entry");
        selector.add("e_schemeid");
        selector.add("e_isselect");
        selector.add("relatescheme");
        selector.add("tradechannel");
        selector.add("org");
        selector.add("finorginfo");
        selector.add("prenoticeday");
        selector.add("amount");
        selector.add("intdate");
        selector.add("term");
        selector.add("deadline");
        selector.add("expiredate");
        selector.add("interesttype");
        selector.add("interestrate");
        selector.add("referencerate");
        selector.add("ratesign");
        selector.add("ratefloatpoint");
        selector.add("profitamount");
        selector.add("expireredeposit");
        selector.add("releaseamount");
        selector.add("estimatedate");
        selector.add("releasetype");
        selector.add("currency");
        selector.add("investvarieties");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> schemeIds = new ArrayList<Long>();
        for (DynamicObject depositApply : dataEntities) {
            String applyType = depositApply.getString("applytype");
            if (!StringUtils.equals((CharSequence)DepositApplyTypeEnum.DEPOSIT.getValue(), (CharSequence)applyType)) continue;
            depositApply.set("relatescheme", (Object)false);
            DynamicObjectCollection entryList = depositApply.getDynamicObjectCollection("entry");
            if (CollectionUtils.isEmpty((Collection)entryList)) continue;
            for (DynamicObject row : entryList) {
                Long schemeId = row.getLong("e_schemeid");
                schemeIds.add(schemeId);
            }
            this.clearSchemeInfo(depositApply);
        }
        this.syncSchemeStatus(schemeIds);
    }

    private void clearSchemeInfo(DynamicObject depositApply) {
        depositApply.set("tradechannel", (Object)"");
        depositApply.set("org", (Object)0L);
        depositApply.set("finorginfo", (Object)0L);
        depositApply.set("prenoticeday", (Object)"");
        depositApply.set("amount", (Object)0);
        depositApply.set("intdate", null);
        depositApply.set("term", (Object)"");
        depositApply.set("deadline", (Object)"");
        depositApply.set("expiredate", null);
        depositApply.set("interesttype", (Object)"");
        depositApply.set("interestrate", (Object)0);
        depositApply.set("referencerate", (Object)0);
        depositApply.set("ratesign", (Object)"");
        depositApply.set("ratefloatpoint", (Object)0);
        depositApply.set("profitamount", (Object)0);
        depositApply.set("expireredeposit", (Object)"");
        depositApply.set("releaseamount", (Object)0);
        depositApply.set("estimatedate", null);
        depositApply.set("releasetype", (Object)"");
        depositApply.set("currency", null);
        depositApply.set("investvarieties", null);
    }

    private void syncSchemeStatus(List<Long> schemeIds) {
        DynamicObject[] depositSchemes;
        for (DynamicObject depositScheme : depositSchemes = TmcDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_depositscheme"))) {
            depositScheme.set("status", (Object)BillStatusEnum.SAVE.getValue());
            depositScheme.set("bizstatus", (Object)SchemeBizStatusEnum.UNDETERMINED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])depositSchemes);
    }
}

