/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.mservice.consistency.bean.CimConsistencyInfo;
import kd.tmc.cim.mservice.consistency.callback.PushCasBillDtxCallback;
import kd.tmc.cim.mservice.consistency.helper.CimConsistencyServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DepositDealAuditService
extends AbstractTmcBizOppService {
    private static final String selectProps = "bizstatus,amount,redeemamount,surplusamount,cleardate,billno";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizstatus");
        selector.add("apply");
        selector.add("bankcheckflag");
        selector.add("finorginfo");
        selector.add("tradechannel");
        selector.add("amount");
        selector.add("isredepositgenerate");
        selector.add("srcdepositno");
        selector.add("intdate");
        selector.add("bizdate");
        selector.add("isinit");
        selector.add("handredeemamt");
        selector.add("iscreatewhenrelease");
        selector.add("investvarieties");
        selector.add("currency.id");
        selector.add("org.id");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.setCurrentDeposit(dataEntities);
        this.updateSrcDepositBill(dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        this.writeBackDepositApply(dataEntities);
        this.pushPayInfo(dataEntities);
    }

    private void pushPayInfo(DynamicObject[] dataEntities) {
        List autoPushBills = Arrays.stream(dataEntities).filter(this::isAutoPushPayInfo).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(autoPushBills)) {
            Pair<String, String> entityPair = this.getEntityPair(dataEntities[0]);
            TmcOperateServiceHelper.execOperate((String)"pushtranshandlebill", (String)((String)entityPair.getRight()), (Object[])autoPushBills.toArray(), (OperateOption)OperateOption.create());
            if (DepositHelper.isCimRelateAppSet()) {
                CimConsistencyInfo consistencyInfo = CimConsistencyInfo.build((String)"deposit_asyncPushPay", (String)"depositBillPushPayService", autoPushBills).setIfmEntityName((String)entityPair.getRight()).setCimEntityName((String)entityPair.getLeft()).setCallback((DTXCallback)new PushCasBillDtxCallback());
                CimConsistencyServiceHelper.asyncPush((CimConsistencyInfo)consistencyInfo);
            }
        }
    }

    private boolean isAutoPushPayInfo(DynamicObject depositBill) {
        return !depositBill.getBoolean("isredepositgenerate") && !depositBill.getBoolean("isinit") && DepositHelper.isSettleCenterBill((DynamicObject)depositBill);
    }

    private void writeBackDepositApply(DynamicObject[] dataEntities) {
        DynamicObject[] depositArr = (DynamicObject[])Arrays.stream(dataEntities).filter(r -> !StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)r.getString("tradechannel"))).toArray(DynamicObject[]::new);
        DepositHelper.writeBackDepositApply((DynamicObject[])depositArr, (boolean)false);
    }

    private void setCurrentDeposit(DynamicObject[] dataEntities) {
        for (DynamicObject depositBill : dataEntities) {
            depositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_done.getValue());
        }
    }

    private void updateSrcDepositBill(DynamicObject[] dataEntities) {
        String skipFlag = (String)this.getOperationVariable().get("skipredepositvalidate");
        if (EmptyUtil.isNoEmpty((String)skipFlag)) {
            return;
        }
        List<String> srcBillNos = Arrays.stream(dataEntities).filter(r -> r.getBoolean("isredepositgenerate")).filter(r -> !r.getBoolean("iscreatewhenrelease")).map(r -> r.getString("srcdepositno")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(srcBillNos)) {
            return;
        }
        this.updateSrcDeposit(dataEntities, srcBillNos);
        String dptDealName = dataEntities[0].getDynamicObjectType().getName();
        this.doRevenueAudit(srcBillNos, dptDealName);
    }

    private void updateSrcDeposit(DynamicObject[] dataEntities, List<String> srcBillNos) {
        DynamicObject[] srcDepositBills;
        Map<String, DynamicObject> srcNo2RedepositMap = Arrays.stream(dataEntities).filter(r -> r.getBoolean("isredepositgenerate")).collect(Collectors.toMap(r -> r.getString("srcdepositno"), r -> r));
        for (DynamicObject srcDepositBill : srcDepositBills = TmcDataServiceHelper.load((String)dataEntities[0].getDynamicObjectType().getName(), (String)selectProps, (QFilter[])new QFilter[]{new QFilter("billno", "in", srcBillNos)})) {
            srcDepositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_end.getValue());
            srcDepositBill.set("redeemamount", (Object)srcDepositBill.getBigDecimal("amount"));
            srcDepositBill.set("surplusamount", (Object)0);
            DynamicObject redepositBill = srcNo2RedepositMap.get(srcDepositBill.getString("billno"));
            srcDepositBill.set("cleardate", (Object)redepositBill.getDate("intdate"));
        }
        SaveServiceHelper.update((DynamicObject[])srcDepositBills);
    }

    private void doRevenueAudit(List<String> srcBillNos, String dptDealName) {
        List srcDepositIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_deposit", (QFilter[])new QFilter[]{new QFilter("billno", "in", srcBillNos)}, (String)"", (int)-1);
        QFilter qFilter = new QFilter("sourcebillid", "in", (Object)srcDepositIds);
        qFilter.and(new QFilter("revenuesort", "=", (Object)RevenueSortEnum.redeposit_revenue.getValue()));
        String entityName = dptDealName.startsWith("ifm") ? "ifm_dptrevenue" : "cim_dptrevenue";
        List revenueIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)revenueIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("const_operate_var", "fromRedeposit");
        TmcOperateServiceHelper.execOperate((String)"audit", (String)entityName, (Object[])revenueIds.toArray(), (OperateOption)option);
    }

    private Pair<String, String> getEntityPair(DynamicObject depositBill) {
        if (DepositHelper.isNoticeDeposit((DynamicObject)depositBill)) {
            return Pair.of((Object)"cim_noticedeposit", (Object)"ifm_notice_deposit");
        }
        return Pair.of((Object)"cim_deposit", (Object)"ifm_deposit");
    }
}

