/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealSaveSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("apply");
        selector.add("isredepositgenerate");
        selector.add("srcdepositid");
        selector.add("investvarieties");
        selector.add("prenoticeday");
        selector.add("intdate");
        selector.add("canredepositdate");
        selector.add("finorginfo");
        selector.add("scorg");
        selector.add("accepttransfer");
        selector.add("amount");
        selector.add("transferamount");
        selector.add("tradechannel");
        selector.add("deadline");
        selector.add("transferdate");
        selector.add("sourcebillid");
        selector.add("demandrate");
        selector.add("term");
        selector.add("expiredate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject deposit : dataEntities) {
            this.dealCurrentBill(deposit);
            DepositHelper.setScOrg((DynamicObject)deposit);
            DepositHelper.setDepositBillValues((DynamicObject)deposit);
        }
        DepositHelper.resetRevenueProjectEntry(Arrays.asList(dataEntities));
        this.writeBackDepositApply(dataEntities);
    }

    private void dealCurrentBill(DynamicObject depositBill) {
        String investType;
        if (!TradeChannelEnum.isOnLine((String)depositBill.getString("tradechannel"))) {
            depositBill.set("deadline", null);
        }
        if (depositBill.getBoolean("accepttransfer")) {
            depositBill.set("demandrate", (Object)BigDecimal.ZERO);
        }
        if (!InvestTypeEnum.isNotice((String)(investType = depositBill.getString("investvarieties.investtype")))) {
            depositBill.set("prenoticeday", null);
        } else {
            depositBill.set("term", null);
            depositBill.set("expiredate", null);
            depositBill.set("canredepositdate", (Object)DepositHelper.getAutoReDepositDate((DynamicObject)depositBill));
        }
    }

    private void writeBackDepositApply(DynamicObject[] depositBills) {
        this.dealDepositApplyByHandAdd(depositBills);
        List depositBillList = Arrays.stream(depositBills).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("apply"))).collect(Collectors.toList());
        Set applyIds = depositBillList.stream().map(d -> d.getLong("apply.id")).collect(Collectors.toSet());
        Object[] depositApplys = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"id,applystatus", (QFilter[])new QFilter("id", "in", applyIds).toArray());
        if (EmptyUtil.isEmpty((Object[])depositApplys)) {
            return;
        }
        for (Object depositApply : depositApplys) {
            String currentStatus = depositApply.getString("applystatus");
            String applyStatus = DepositApplyStatusEnum.PARTHANDLED.getValue().equals(currentStatus) ? currentStatus : DepositApplyStatusEnum.HANDING.getValue();
            depositApply.set("applystatus", (Object)applyStatus);
        }
        SaveServiceHelper.save((DynamicObject[])depositApplys);
        for (DynamicObject depositBill : depositBillList) {
            this.dealSrcBillBotpRelation(depositBill);
        }
    }

    private void dealDepositApplyByHandAdd(DynamicObject[] depositBills) {
        List handDynList = Arrays.stream(depositBills).filter(r -> EmptyUtil.isEmpty((Long)r.getLong("sourcebillid"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(handDynList)) {
            return;
        }
        ArrayList<Object> srcApplyList = new ArrayList<Object>(depositBills.length);
        for (DynamicObject depositBill : depositBills) {
            Object[] applyIds = TmcBotpHelper.getSourceBillIds((String)depositBill.getDynamicObjectType().getName(), (Object)depositBill.getPkValue(), (String)"cim_deposit_apply");
            if (!EmptyUtil.isNoEmpty((Object[])applyIds)) continue;
            srcApplyList.addAll(Arrays.asList(applyIds));
            for (Object applyId : applyIds) {
                TmcBotpHelper.deleteRation((String)depositBill.getDynamicObjectType().getName(), (Long)applyId, (Long)depositBill.getLong("id"));
            }
        }
        if (EmptyUtil.isEmpty(srcApplyList)) {
            return;
        }
        Object[] depositApplys = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"id,applystatus", (QFilter[])new QFilter("id", "in", srcApplyList).toArray());
        if (EmptyUtil.isEmpty((Object[])depositApplys)) {
            return;
        }
        for (Object depositApply : depositApplys) {
            String currentStatus = depositApply.getString("applystatus");
            String applyStatus = DepositApplyStatusEnum.PARTHANDLED.getValue().equals(currentStatus) ? currentStatus : DepositApplyStatusEnum.UNHANDLE.getValue();
            depositApply.set("applystatus", (Object)applyStatus);
        }
        SaveServiceHelper.save((DynamicObject[])depositApplys);
    }

    private void dealSrcBillBotpRelation(DynamicObject deposit) {
        if (EmptyUtil.isNoEmpty((Long)deposit.getLong("sourcebillid"))) {
            return;
        }
        Long applyId = Optional.ofNullable(deposit.getDynamicObject("apply")).map(r -> r.getLong("id")).orElse(0L);
        String currentEntity = deposit.getDynamicObjectType().getName();
        DepositHelper.deleteBotpRation((String)currentEntity, (Long)deposit.getLong("id"), (String)"cim_deposit_apply", (Long)applyId);
        if (EmptyUtil.isNoEmpty((Long)applyId)) {
            TmcBotpHelper.saveRelation((String)"cim_deposit_apply", (Long)applyId, (String)currentEntity, (Long)deposit.getLong("id"));
        }
    }
}

