/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.bean.RevenueConvertParam;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("surplusamount");
        selector.add("amount");
        selector.add("intdate");
        selector.add("expiredate");
        selector.add("investvarieties");
        selector.add("planamount");
        selector.add("productfactory");
        selector.add("basis");
        selector.add("interesttype");
        selector.add("interestrate");
        selector.add("referencerate");
        selector.add("ratesign");
        selector.add("ratefloatpoint");
        selector.add("prenoticeday");
        selector.add("canredepositdate");
        selector.add("revenueproject");
        selector.add("isredepositgenerate");
        selector.add("srcprincipal");
        selector.add("srcinterest");
        selector.add("revenue_entry.seq");
        selector.add("revenue_entry.revenueseq");
        selector.add("revenue_entry.revenuedate");
        selector.add("revenue_entry.revenuecalamount");
        selector.add("revenue_entry.revenuestate");
        selector.add("revenue_subentry.seq");
        selector.add("revenue_subentry.startdate");
        selector.add("revenue_subentry.enddate");
        selector.add("revenue_subentry.days");
        selector.add("revenue_subentry.finamount");
        selector.add("revenue_subentry.eplanrevenue");
        selector.add("revenue_subentry.convertdays");
        selector.add("revenue_subentry.erevenueamount");
        selector.add("finorginfo");
        selector.add("billtype");
        selector.add("workcalendar");
        selector.add("isinit");
        selector.add("lastrevenuedate");
        selector.add("redeemamount");
        selector.add("handlastrevenuedate");
        selector.add("finorginfo");
        selector.add("scorg");
        selector.add("handinstplan");
        selector.add("endpreinstdate");
        selector.add("accepttransfer");
        selector.add("transferdate");
        selector.add("handendpredate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.dealRevenueWhenRedeposit(dataEntities);
    }

    private void dealRevenueWhenRedeposit(DynamicObject[] dataEntitys) {
        Map opMap = this.getOperationVariable();
        if (EmptyUtil.isNoEmpty((String)((String)opMap.get("skipredepositrevenue")))) {
            return;
        }
        List depositBills = Arrays.stream(dataEntitys).filter(d -> d.getBoolean("isredepositgenerate")).collect(Collectors.toList());
        Set srcDepositNos = depositBills.stream().filter(d -> EmptyUtil.isNoEmpty((String)d.getString("srcdepositno"))).map(d -> d.getString("srcdepositno")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(srcDepositNos)) {
            return;
        }
        DynamicObjectCollection srcDepositBills = QueryServiceHelper.query((String)"cim_deposit", (String)"id,billno,lastrevenuedate,expiredate,investvarieties.investtype as investtype", (QFilter[])new QFilter("billno", "in", srcDepositNos).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)srcDepositBills)) {
            return;
        }
        RevenueConvertParam convertParam = new RevenueConvertParam("fromRedeposit");
        Map<String, List<DynamicObject>> srcDepositBillMap = srcDepositBills.stream().collect(Collectors.groupingBy(d -> d.getString("billno")));
        for (DynamicObject depositBill : depositBills) {
            String srcDepositNo = depositBill.getString("srcdepositno");
            List<DynamicObject> srcDepositBillList = srcDepositBillMap.get(srcDepositNo);
            if (EmptyUtil.isEmpty(srcDepositBillList)) continue;
            HashSet<Long> srcDepositIds = new HashSet<Long>(srcDepositBillList.size());
            for (DynamicObject srcDepositBill : srcDepositBillList) {
                Date lastRevenueDate = srcDepositBill.getDate("lastrevenuedate");
                Date expireDate = srcDepositBill.getDate("expiredate");
                if (InvestTypeEnum.isFixed((String)srcDepositBill.getString("investtype")) && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{lastRevenueDate, expireDate}) && DateUtils.getNextDay((Date)lastRevenueDate, (int)1).compareTo(expireDate) >= 0) continue;
                srcDepositIds.add(srcDepositBill.getLong("id"));
            }
            if (EmptyUtil.isEmpty(srcDepositIds)) continue;
            for (Long srcDepositId : srcDepositIds) {
                RevenueConvertParam.SourceParam sourceParam = new RevenueConvertParam.SourceParam(srcDepositId);
                sourceParam.addOption("bizdate", DateUtils.formatString((Date)depositBill.getDate("intdate"), (String)"yyyy-MM-dd")).addOption("expireredeposit", depositBill.getString("srcexpireredeposit")).addOption("actpreinstamt", depositBill.getBigDecimal("srcinterest").toString());
                convertParam.addParam(sourceParam);
            }
        }
        if (!convertParam.isEmpty()) {
            List srcDepositIds = convertParam.getParams().stream().map(RevenueConvertParam.SourceParam::getSourceBillId).collect(Collectors.toList());
            OperateOption option = OperateOption.create();
            option.setVariableValue("const_operate_var", "fromRedeposit");
            option.setVariableValue("const_operate_params", SerializationUtils.toJsonString((Object)convertParam));
            TmcOperateServiceHelper.execOperate((String)"push2revenue", (String)((DynamicObject)depositBills.get(0)).getDynamicObjectType().getName(), (Object[])srcDepositIds.toArray(), (OperateOption)option);
        }
    }
}

