/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealUnSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("isredepositgenerate");
        selector.add("srcdepositno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<String> srcDepositNoList = Arrays.stream(dataEntities).filter(r -> r.getBoolean("isredepositgenerate")).map(r -> r.getString("srcdepositno")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(srcDepositNoList)) {
            return;
        }
        this.dealRevenueOfSrcDeposit(srcDepositNoList, dataEntities[0].getDynamicObjectType().getName());
    }

    private void dealRevenueOfSrcDeposit(List<String> srcBillNos, String currentDepositEntity) {
        List submitIds;
        QFilter qFilter = new QFilter("loanbillno", "in", srcBillNos);
        qFilter.and("revenuesort", "=", (Object)RevenueSortEnum.redeposit_revenue.getValue());
        DynamicObjectCollection revenues = QueryServiceHelper.query((String)"cim_dptrevenue", (String)"id,billstatus", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)revenues)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("fromReleaseAudit", "true");
        String revenueEntity = currentDepositEntity.startsWith("ifm") ? "ifm_dptrevenue" : "cim_dptrevenue";
        List auditIds = revenues.stream().filter(d -> BillStatusEnum.isAudit((String)d.getString("billstatus"))).map(d -> d.getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(auditIds)) {
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)revenueEntity, (Object[])auditIds.toArray(), (OperateOption)option);
        }
        if (EmptyUtil.isNoEmpty(submitIds = revenues.stream().filter(d -> BillStatusEnum.isSubmit((String)d.getString("billstatus"))).map(d -> d.getLong("id")).collect(Collectors.toList()))) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)revenueEntity, (Object[])submitIds.toArray(), (OperateOption)option);
        }
        List revenueIds = revenues.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        TmcOperateServiceHelper.execOperate((String)"delete", (String)revenueEntity, (Object[])revenueIds.toArray(), (OperateOption)option);
    }
}

