/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositIntPreAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("operatetype");
        selector.add("prestenddate");
        selector.add("entrys");
        selector.add("entrys.instenddate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> depositBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject intPreBill : dataEntities) {
            if (StringUtils.equals((CharSequence)PreIntOperateTypeEnum.REVERSEINT.getValue(), (CharSequence)intPreBill.getString("operatetype"))) continue;
            long sourceBillId = intPreBill.getLong("sourcebillid");
            DynamicObject depositBill = TmcDataServiceHelper.loadSingle((Object)sourceBillId, (String)"cim_deposit", (String)"endpreinstdate");
            DynamicObjectCollection rows = intPreBill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)rows)) continue;
            Date endPreIntDate = rows.stream().map(r -> r.getDate("instenddate")).max(Date::compareTo).orElseGet(() -> DateUtils.getNextDay((Date)intPreBill.getDate("prestenddate"), (int)-1));
            depositBill.set("endpreinstdate", (Object)endPreIntDate);
            depositBillList.add(depositBill);
        }
        SaveServiceHelper.save((DynamicObject[])depositBillList.toArray(new DynamicObject[0]));
    }
}

