/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositIntPreSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        return super.getSelector();
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        if (this.getOperationVariable().containsKey("redwriteoffop")) {
            return;
        }
        for (DynamicObject preintBill : dataEntities) {
            this.dealAutoRedWriteOff(preintBill);
        }
    }

    private void dealAutoRedWriteOff(DynamicObject preintBill) {
        if (!this.isAutoWriteRed(preintBill)) {
            return;
        }
        QFilter filter = new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("loanbillno", "=", (Object)preintBill.getString("loanbillno"));
        Object[] unWriteOffPreIntBills = TmcDataServiceHelper.load((String)"cim_depositpreint", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((Object[])unWriteOffPreIntBills)) {
            return;
        }
        long batchNoId = preintBill.getLong("id");
        preintBill.set("batchnoid", (Object)batchNoId);
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("autoredwriteoff", "true");
        operate.setVariableValue("back", "true");
        operate.setVariableValue("redwriteoffbatch", String.valueOf(batchNoId));
        Object[] ids = Arrays.stream(unWriteOffPreIntBills).map(DataEntityBase::getPkValue).toArray();
        TmcOperateServiceHelper.execOperate((String)"redwriteoff", (String)"cim_depositpreint", (Object[])ids, (OperateOption)operate);
    }

    private boolean isAutoWriteRed(DynamicObject preintBill) {
        String param = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.CIM.getId(), (long)preintBill.getLong("org_id"), (String)"autoredwriteoff");
        return EmptyUtil.isNoEmpty((String)param) && StringUtils.equals((CharSequence)param, (CharSequence)"true");
    }
}

