/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositIntPreUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("prestenddate");
        selector.add("intbatchbillid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> depositBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject intPreBill : dataEntities) {
            DynamicObject depositBill = TmcDataServiceHelper.loadSingle((Object)intPreBill.getLong("sourcebillid"), (String)"cim_deposit", (String)"id,endpreinstdate,isinit,handendpredate,lastrevenuedate,accepttransfer,transferdate");
            Date lastPayIntDate = this.queryNearestPreEndDate(depositBill, intPreBill);
            if (depositBill.getBoolean("isinit") && null == lastPayIntDate) {
                depositBill.set("endpreinstdate", (Object)depositBill.getDate("handendpredate"));
            } else {
                depositBill.set("endpreinstdate", (Object)lastPayIntDate);
            }
            depositBillList.add(depositBill);
        }
        SaveServiceHelper.save((DynamicObject[])depositBillList.toArray(new DynamicObject[0]));
    }

    private Date queryNearestPreEndDate(DynamicObject depositBill, DynamicObject intPreBill) {
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)depositBill.getLong("id"));
        qFilter.and("id", "!=", intPreBill.getPkValue());
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        qFilter.and("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        DynamicObjectCollection intPreCols = QueryServiceHelper.query((String)intPreBill.getDataEntityType().getName(), (String)"prestenddate", (QFilter[])qFilter.toArray(), (String)"prestenddate desc");
        Date minDate = DateUtils.stringToDate((String)"1970-01-01", (String)"yyyy-MM-dd");
        minDate = depositBill.getBoolean("accepttransfer") && EmptyUtil.isNoEmpty((Object)depositBill.getDate("transferdate")) ? DateUtils.getLastDay((Date)depositBill.getDate("transferdate"), (int)1) : minDate;
        Date lstDate1 = EmptyUtil.isNoEmpty((DynamicObjectCollection)intPreCols) ? DateUtils.getNextDay((Date)((DynamicObject)intPreCols.get(0)).getDate("prestenddate"), (int)-1) : minDate;
        Date lstDate2 = Optional.ofNullable(depositBill.getDate("lastrevenuedate")).orElse(minDate);
        Date lstPayIntDate = lstDate1.compareTo(lstDate2) >= 0 ? lstDate1 : lstDate2;
        lstPayIntDate = lstPayIntDate.compareTo(DateUtils.stringToDate((String)"1970-01-01", (String)"yyyy-MM-dd")) == 0 ? null : lstPayIntDate;
        return lstPayIntDate;
    }
}

