/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.mservice.consistency.bean.CimConsistencyInfo;
import kd.tmc.cim.mservice.consistency.callback.PushCasBillDtxCallback;
import kd.tmc.cim.mservice.consistency.helper.CimConsistencyServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DepositReleaseAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("finbillno");
        selector.add("amount");
        selector.add("realrevenue");
        selector.add("redeemdate");
        selector.add("apply");
        selector.add("sourcebillid");
        selector.add("redepositamount");
        selector.add("tradechannel");
        selector.add("bankcheckflag");
        selector.add("finorginfo");
        selector.add("amount");
        selector.add("bebankstatus");
        selector.add("isresubmit");
        selector.add("investvarieties");
        selector.add("isrevenue");
        selector.add("releasetype");
        selector.add("currency");
        selector.add("interestrate");
        selector.add("isinit");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        this.writeBackApplyBill(dataEntities);
        this.dealReDeposit(dataEntities);
        this.pushRecInfo(dataEntities);
    }

    private void pushRecInfo(DynamicObject[] releaseBills) {
        List autoPushBills = Arrays.stream(releaseBills).filter(this::isAutoPushPayInfo).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(autoPushBills)) {
            Pair<String, String> entityPair = this.getEntityPair(releaseBills[0]);
            String entityName = (String)entityPair.getRight();
            TmcOperateServiceHelper.execOperate((String)"pushtranshandlebill", (String)entityName, (Object[])autoPushBills.toArray(), (OperateOption)OperateOption.create());
            if (DepositHelper.isCimRelateAppSet()) {
                CimConsistencyInfo consistencyInfo = CimConsistencyInfo.build((String)"release_asyncPushRec", (String)"releaseBillPushRecService", autoPushBills).setIfmEntityName((String)entityPair.getRight()).setCimEntityName((String)entityPair.getLeft()).setCallback((DTXCallback)new PushCasBillDtxCallback());
                CimConsistencyServiceHelper.asyncPush((CimConsistencyInfo)consistencyInfo);
            }
        }
    }

    private void dealReDeposit(DynamicObject[] releaseBills) {
        DynamicObject[] depositBills;
        Map<Long, DynamicObject> releaseBillMap = Arrays.stream(releaseBills).filter(d -> !TradeChannelEnum.isOnLine((String)d.getString("tradechannel"))).collect(Collectors.toMap(r -> r.getLong("finbillno.id"), r -> r));
        if (EmptyUtil.isEmpty(releaseBillMap)) {
            return;
        }
        String entityName = DepositHelper.isSettleCenterBill((DynamicObject)releaseBills[0]) ? "ifm_deposit" : "cim_deposit";
        for (DynamicObject depositBill : depositBills = TmcDataServiceHelper.load((Object[])releaseBillMap.keySet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName))) {
            DynamicObject releaseBill = releaseBillMap.get(depositBill.getLong("id"));
            if (!EmptyUtil.isNoEmpty((DynamicObject)releaseBill) || TradeChannelEnum.isOnLine((String)releaseBill.getString("tradechannel"))) continue;
            DepositHelper.setSrcDepositBillValues((DynamicObject)depositBill, (DynamicObject)releaseBill);
        }
        SaveServiceHelper.save((DynamicObject[])depositBills);
    }

    private void writeBackApplyBill(DynamicObject[] depositReleaseBills) {
        List releaseBills = Arrays.stream(depositReleaseBills).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("apply"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(releaseBills)) {
            return;
        }
        Set applyIds = releaseBills.stream().map(d -> d.getLong("apply.id")).collect(Collectors.toSet());
        Object[] releaseApplys = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"applystatus", (QFilter[])new QFilter("id", "in", applyIds).toArray());
        if (EmptyUtil.isEmpty((Object[])releaseApplys)) {
            return;
        }
        for (Object releaseApply : releaseApplys) {
            releaseApply.set("applystatus", (Object)DepositApplyStatusEnum.HANDLED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])releaseApplys);
    }

    private Pair<String, String> getEntityPair(DynamicObject releaseBill) {
        if (DepositHelper.isNoticeDeposit((DynamicObject)releaseBill)) {
            return Pair.of((Object)"cim_noticerelease", (Object)"ifm_notice_release");
        }
        return Pair.of((Object)"cim_release", (Object)"ifm_release");
    }

    private boolean isAutoPushPayInfo(DynamicObject releaseBill) {
        return !releaseBill.getBoolean("isinit") && DepositHelper.isSettleCenterBill((DynamicObject)releaseBill);
    }
}

