/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyStatusEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.mq.TmcMQParam;
import kd.tmc.fbp.common.mq.TmcMQTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositReleaseUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("finbillno");
        selector.add("finorginfo");
        selector.add("amount");
        selector.add("realrevenue");
        selector.add("apply");
        selector.add("sourcebillid");
        selector.add("tradechannel");
        selector.add("isrevenue");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.writeBackApplyBill(dataEntities);
        this.deleteRevenueInfo(dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        Map<Long, DynamicObject> releaseBillMap = Arrays.stream(dataEntities).collect(Collectors.toMap(r -> r.getDynamicObject("finbillno").getLong("id"), r -> r));
        if (EmptyUtil.isEmpty(releaseBillMap)) {
            return;
        }
        this.updateSrcDepositBillValues(releaseBillMap);
        this.deleteTargetBills(dataEntities);
    }

    private void updateSrcDepositBillValues(Map<Long, DynamicObject> releaseBillMap) {
        Map opMap = this.getOperationVariable();
        boolean isFromApplyCancel = EmptyUtil.isNoEmpty((String)((String)opMap.get("fromApplyCancel")));
        ArrayList<Long> depositIds = new ArrayList<Long>(releaseBillMap.size());
        for (Map.Entry<Long, DynamicObject> entry : releaseBillMap.entrySet()) {
            DynamicObject releaseBill = entry.getValue();
            if (TradeChannelEnum.isOnLine((String)releaseBill.getString("tradechannel")) && !isFromApplyCancel) continue;
            depositIds.add(entry.getKey());
        }
        if (EmptyUtil.isEmpty(depositIds)) {
            return;
        }
        DynamicObject[] depositBills = TmcDataServiceHelper.load((Object[])depositIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_deposit"));
        Map<Long, Date> maxRedeemDateMap = this.getMaxRedeemDateFromReleaseBill(depositIds);
        for (DynamicObject depositBill : depositBills) {
            long depositId = depositBill.getLong("id");
            DynamicObject releaseBill = releaseBillMap.get(depositId);
            depositBill.set("lastredeemdate", (Object)maxRedeemDateMap.get(depositId));
            depositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_part.getValue());
            BigDecimal curRedAmount = releaseBill.getBigDecimal("amount");
            BigDecimal redeemAmount = depositBill.getBigDecimal("redeemamount").subtract(curRedAmount);
            depositBill.set("redeemamount", (Object)redeemAmount);
            BigDecimal surAmount = depositBill.getBigDecimal("surplusamount");
            BigDecimal calSurAmount = surAmount.add(curRedAmount);
            depositBill.set("surplusamount", (Object)calSurAmount);
            if (redeemAmount.compareTo(BigDecimal.ZERO) == 0) {
                depositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_done.getValue());
            }
            depositBill.set("cleardate", null);
            DepositHelper.resetRevenueProjectEntry((DynamicObject)depositBill);
        }
        SaveServiceHelper.save((DynamicObject[])depositBills);
    }

    private void writeBackApplyBill(DynamicObject[] dataEntities) {
        DynamicObject[] applyBills;
        Map opMap = this.getOperationVariable();
        if (EmptyUtil.isNoEmpty((String)((String)opMap.get("fromApplyCancel")))) {
            return;
        }
        ArrayList<DynamicObject> applys = new ArrayList<DynamicObject>(dataEntities.length);
        Map<Long, DynamicObject> applyBillMap = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((DynamicObject)r.getDynamicObject("apply"))).collect(Collectors.toMap(r -> (Long)r.getDynamicObject("apply").getPkValue(), r -> r));
        if (EmptyUtil.isEmpty(applyBillMap)) {
            return;
        }
        for (DynamicObject applyBill : applyBills = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"id,applystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillMap.keySet())})) {
            applyBill.set("applystatus", (Object)DepositApplyStatusEnum.HANDING.getValue());
            applys.add(applyBill);
        }
        SaveServiceHelper.save((DynamicObject[])applys.toArray(new DynamicObject[0]));
    }

    private Map<Long, Date> getMaxRedeemDateFromReleaseBill(List<Long> depositIds) {
        HashMap<Long, Date> dateMap = new HashMap<Long, Date>(depositIds.size());
        QFilter qFilter = new QFilter("sourcebillid", "in", depositIds).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection releaseCol = QueryServiceHelper.query((String)"cim_release", (String)"sourcebillid,redeemdate", (QFilter[])qFilter.toArray());
        Map<Long, Optional<DynamicObject>> redeemDateMap = releaseCol.stream().collect(Collectors.groupingBy(d -> d.getLong("sourcebillid"), Collectors.maxBy(Comparator.comparing(d -> d.getDate("redeemdate")))));
        for (Map.Entry<Long, Optional<DynamicObject>> entry : redeemDateMap.entrySet()) {
            entry.getValue().ifPresent(dynamicObject -> dateMap.put((Long)entry.getKey(), dynamicObject.getDate("redeemdate")));
        }
        return dateMap;
    }

    private void deleteTargetBills(DynamicObject[] dataEntities) {
        Object[] ids = Arrays.stream(dataEntities).filter(DepositHelper::isSettleCenterBill).map(DataEntityBase::getPkValue).toArray();
        if (EmptyUtil.isNoEmpty((Object[])ids)) {
            HashMap<String, Object> msgParamMap = new HashMap<String, Object>();
            QFilter filter = new QFilter("sourcebillid", "in", (Object)ids);
            DynamicObjectCollection transHandleBills = QueryServiceHelper.query((String)"ifm_transhandlebill", (String)"id", (QFilter[])filter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)transHandleBills)) {
                Object[] transBillIds = transHandleBills.stream().map(v -> v.get("id")).toArray();
                msgParamMap.put("ifmentityname", "ifm_transhandlebill");
                msgParamMap.put("transbillids", transBillIds);
            }
            filter.and("billstatus", "!=", (Object)"G");
            DynamicObjectCollection recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id", (QFilter[])filter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recBills)) {
                Object[] recBillIds = recBills.stream().map(v -> v.get("id")).toArray();
                msgParamMap.put("casentityname", "cas_recbill");
                msgParamMap.put("recpayids", recBillIds);
            }
            if (EmptyUtil.isNoEmpty(msgParamMap)) {
                TmcMQParam.build((TmcMQTypeEnum)TmcMQTypeEnum.AUTO_ASYNC_DEL_RECPAY, msgParamMap).sendMessageInDbTranscation("kd.tmc.ifm.trans");
            }
        }
    }

    private void deleteRevenueInfo(DynamicObject[] depositReleases) {
        List releaseIds = Arrays.stream(depositReleases).map(d -> d.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection revenueBills = QueryServiceHelper.query((String)"cim_dptrevenue", (String)"id,billstatus,srcreleaseid", (QFilter[])new QFilter("srcreleaseid", "in", releaseIds).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)revenueBills)) {
            return;
        }
        String releaseBillName = depositReleases[0].getDataEntityType().getName();
        String renevueName = releaseBillName.startsWith("cim") ? "cim_dptrevenue" : "ifm_dptrevenue";
        Map<Long, Long> releaseIdMap = revenueBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getLong("srcreleaseid")));
        Map<String, List<DynamicObject>> revenueBillMap = revenueBills.stream().collect(Collectors.groupingBy(d -> d.getString("billstatus")));
        for (Map.Entry<String, List<DynamicObject>> entry : revenueBillMap.entrySet()) {
            String billStatus = entry.getKey();
            ArrayList<String> operateKeys = new ArrayList<String>(2);
            List revenueIds = entry.getValue().stream().map(d -> d.getLong("id")).collect(Collectors.toList());
            if (BillStatusEnum.isAudit((String)billStatus)) {
                operateKeys.add("unaudit");
            } else if (BillStatusEnum.isSubmit((String)billStatus)) {
                operateKeys.add("unsubmit");
            }
            operateKeys.add("delete");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ignorerevenue", "true");
            operateOption.setVariableValue("fromReleaseAudit", "true");
            for (String operateKey : operateKeys) {
                TmcOperateServiceHelper.execOperate((String)operateKey, (String)renevueName, (Object[])revenueIds.toArray(), (OperateOption)operateOption);
            }
            for (Long revenueId : revenueIds) {
                Long releaseId = releaseIdMap.get(revenueId);
                TmcBotpHelper.deleteRation((String)"cim_dptrevenue", (Long)releaseId, (Long)revenueId);
                TmcBotpHelper.deleteRation((String)"ifm_dptrevenue", (Long)releaseId, (Long)revenueId);
            }
        }
    }

    private void deleteRevenueInfo(DynamicObject depositRelease) {
        String releaseBillName = depositRelease.getDataEntityType().getName();
        String renevueName = releaseBillName.startsWith("cim") ? "cim_dptrevenue" : "ifm_dptrevenue";
        DynamicObject revenueBill = QueryServiceHelper.queryOne((String)"cim_dptrevenue", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("srcreleaseid", "=", depositRelease.getPkValue())});
        if (null != revenueBill) {
            TmcBotpHelper.deleteRation((String)"cim_dptrevenue", (Long)depositRelease.getLong("id"), (Long)revenueBill.getLong("id"));
            TmcBotpHelper.deleteRation((String)"ifm_dptrevenue", (Long)depositRelease.getLong("id"), (Long)revenueBill.getLong("id"));
            ArrayList<String> operateKeys = new ArrayList<String>();
            String billStatus = revenueBill.getString("billstatus");
            if (StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                operateKeys.add("unaudit");
            } else if (StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.SUBMIT.getValue())) {
                operateKeys.add("unsubmit");
            }
            operateKeys.add("delete");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ignorerevenue", "true");
            operateOption.setVariableValue("fromReleaseAudit", "true");
            for (String operateKey : operateKeys) {
                TmcOperateServiceHelper.execOperate((String)operateKey, (String)renevueName, (Object[])new Object[]{revenueBill.getLong("id")}, (OperateOption)operateOption);
            }
        }
    }
}

