/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FixedDepositAutoReleaseService
extends AbstractTmcBizOppService {
    private static final Log LOG = LogFactory.getLog(FixedDepositAutoReleaseService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        OperationResult submitResult;
        List releaseIds;
        OperationResult saveResult;
        LOG.info("AutoRelease schedule task beginning has {} data", (Object)dataEntities.length);
        Map opMap = this.getOperationVariable();
        String revenueBillStatus = BillStatusEnum.SAVE.getValue();
        String billstatusParam = (String)opMap.get("billstatus_param");
        if (EmptyUtil.isNoEmpty((String)billstatusParam)) {
            revenueBillStatus = billstatusParam;
        }
        LOG.info("The schedule param \u2018billstatus_param\u2019 value is {}", (Object)revenueBillStatus);
        Object[] depositIds = Arrays.stream(dataEntities).map(r -> r.getLong("id")).toArray();
        DynamicObjectType entityType = dataEntities[0].getDynamicObjectType();
        String currentEntity = entityType.getName();
        DynamicObject[] depositBills = TmcDataServiceHelper.load((Object[])depositIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)currentEntity));
        String releaseEntity = this.getReleaseEntity(currentEntity);
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject deposit : depositBills) {
            try {
                DynamicObject[] release = TmcBotpHelper.push((DynamicObject)deposit, (String)releaseEntity);
                DynamicObject releaseBill = release[0];
                String releaseRule = Optional.ofNullable(deposit.getDynamicObject("productfactory")).map(r -> r.getString("graceadjustrule")).orElse("");
                DynamicObjectCollection workCalendars = deposit.getDynamicObjectCollection("workcalendar");
                if (EmptyUtil.isNoEmpty((String)releaseRule) && EmptyUtil.isNoEmpty((DynamicObjectCollection)workCalendars)) {
                    AdjustMethodEnum adjustMethod = AdjustMethodEnum.valueOf((String)releaseRule);
                    Date expireDate = deposit.getDate("expiredate");
                    Date adjustExpireDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)expireDate, (AdjustMethodEnum)adjustMethod);
                    releaseBill.set("redeemdate", (Object)adjustExpireDate);
                    releaseBill.set("accountdate", (Object)adjustExpireDate);
                    IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)releaseBill, (boolean)false);
                    BigDecimal rateAmt = intBillInfo.getAmount().setScale(releaseBill.getDynamicObject("currency").getInt("amtprecision"), RoundingMode.HALF_UP);
                    releaseBill.set("predictinstamt", (Object)rateAmt);
                    releaseBill.set("realrevenue", (Object)rateAmt);
                    releaseBill.set("totalamount", (Object)releaseBill.getBigDecimal("amount").add(rateAmt));
                    DepositHelper.addRevenueCalDetailEntry((DynamicObjectCollection)releaseBill.getDynamicObjectCollection("entrys"), (List)intBillInfo.getDetails());
                }
                releaseList.add(releaseBill);
            }
            catch (Exception e) {
                LOG.error("AutoRelease Schedule occured an exception: depositNo={},exception={},e={}", new Object[]{deposit.getString("billno"), e.getMessage(), e});
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("WF", "TRUE");
        try (TXHandle txHandle = TX.requiresNew((String)"cim_deposit_autorelease");){
            saveResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"save", (String)releaseEntity, (DynamicObject[])releaseList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (BillStatusEnum.SAVE.getValue().equals(revenueBillStatus) || EmptyUtil.isEmpty((Object)saveResult) || !saveResult.isSuccess()) {
                return;
            }
            releaseIds = saveResult.getSuccessPkIds();
            LOG.info("AutoRelease schedule task saving has {} data", (Object)releaseIds.size());
            submitResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"submit", (String)releaseEntity, (Object[])releaseIds.toArray(), (OperateOption)option);
        }
        if (BillStatusEnum.AUDIT.getValue().equals(revenueBillStatus) && EmptyUtil.isNoEmpty((Object)submitResult) && submitResult.isSuccess()) {
            releaseIds = submitResult.getSuccessPkIds();
            LOG.info("AutoRelease schedule task submitting has {} data", (Object)releaseIds.size());
            OperationResult auditResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"audit", (String)releaseEntity, (Object[])releaseIds.toArray(), (OperateOption)option);
            LOG.info("AutoRelease schedule task auditting has {} data", (Object)(auditResult != null ? auditResult.getSuccessPkIds().size() : 0));
        }
        this.handleRollBack(saveResult.getSuccessPkIds(), releaseEntity, revenueBillStatus);
    }

    private void handleRollBack(List<Object> ids, String entityName, String billstatus) {
        QFilter filter = new QFilter("id", "in", ids);
        if (BillStatusEnum.isSubmit((String)billstatus)) {
            filter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        } else if (BillStatusEnum.isAudit((String)billstatus)) {
            filter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        }
        DynamicObjectCollection releaseBills = QueryServiceHelper.query((String)entityName, (String)"id,billstatus", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)releaseBills)) {
            Object[] releaseIds;
            Object[] submitIds = releaseBills.stream().filter(v -> BillStatusEnum.isSubmit((String)v.getString("billstatus"))).map(r -> r.get("id")).toArray();
            if (EmptyUtil.isNoEmpty((Object[])submitIds)) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])submitIds, (OperateOption)OperateOption.create(), (boolean)true);
            }
            if (EmptyUtil.isNoEmpty((Object[])(releaseIds = releaseBills.stream().map(r -> r.get("id")).toArray()))) {
                TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])submitIds, (OperateOption)OperateOption.create(), (boolean)true);
            }
        }
    }

    private String getReleaseEntity(String depositEntity) {
        return "cim_deposit".equals(depositEntity) ? "cim_release" : "ifm_release";
    }
}

