/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("prestenddate");
        selector.add("actpreinstamt");
        selector.add("finorginfo");
        selector.add("confirmstatus");
        selector.add("bankcheckflag");
        selector.add("loanbillno");
        selector.add("investvarieties");
        selector.add("revenuesort");
        selector.add("recbillno");
        selector.add("combineinst");
        selector.add("isinit");
        selector.add("bizdate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.autoConfirm(dataEntities);
        this.modifyConfirmStatus(dataEntities);
    }

    private void autoConfirm(DynamicObject[] dataEntities) {
        Object[] revenueBills = (DynamicObject[])Arrays.stream(dataEntities).filter(v -> !DepositHelper.isNeedConfirm((DynamicObject)v)).toArray(DynamicObject[]::new);
        if (EmptyUtil.isNoEmpty((Object[])revenueBills)) {
            TmcOperateServiceHelper.execOperate((String)"confirm", (String)"cim_dptrevenue", (DynamicObject[])revenueBills, (OperateOption)OperateOption.create());
        }
    }

    private void modifyConfirmStatus(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            String confirmStatus = DepositHelper.isNeedConfirm((DynamicObject)dataEntity) ? "waitsubmit" : "yetconfirm";
            dataEntity.set("confirmstatus", (Object)confirmStatus);
        }
    }
}

