/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DptRevenueBatchBindBotpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loanbillid");
        selector.add("status");
        selector.add("intbillid");
        selector.add("loanbillno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        this.dealUpperBotp(dataEntities);
        this.dealDownBotp(dataEntities);
    }

    private void dealUpperBotp(DynamicObject[] dataEntities) {
        Object[] depositIds = Arrays.stream(dataEntities).map(r -> r.getDynamicObjectCollection("entry")).flatMap(Collection::stream).map(r -> r.getLong("loanbillid")).toArray();
        DynamicObjectCollection depositBills = QueryServiceHelper.query((String)"cim_deposit", (String)"id,investvarieties.investtype as investtype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)depositIds)});
        Map<Long, String> idToTypeMap = depositBills.stream().collect(Collectors.toMap(r -> r.getLong("id"), r -> r.getString("investtype")));
        ArrayList<Pair> fixedSrcTarIds = new ArrayList<Pair>(idToTypeMap.size());
        ArrayList<Pair> noticeSrcTarIds = new ArrayList<Pair>(idToTypeMap.size());
        String currentEntity = dataEntities[0].getDynamicObjectType().getName();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Object[] targetBillIds;
                String sourceEntity;
                long depositId = entry.getLong("loanbillid");
                long targetId = dataEntity.getLong("id");
                String investType = idToTypeMap.get(depositId);
                if (EmptyUtil.isNoEmpty((String)investType) && InvestTypeEnum.isNotice((String)investType)) {
                    sourceEntity = this.getUpStreamEntity(currentEntity, "notice");
                    targetBillIds = TmcBotpHelper.getTargetBillIds((String)sourceEntity, (Object)depositId, (String)currentEntity);
                    if (EmptyUtil.isNoEmpty((Object[])targetBillIds) && Arrays.asList(targetBillIds).contains(targetId)) continue;
                    noticeSrcTarIds.add(Pair.of((Object)depositId, (Object)targetId));
                    continue;
                }
                sourceEntity = this.getUpStreamEntity(currentEntity, "fixed");
                targetBillIds = TmcBotpHelper.getTargetBillIds((String)sourceEntity, (Object)depositId, (String)currentEntity);
                if (EmptyUtil.isNoEmpty((Object[])targetBillIds) && Arrays.asList(targetBillIds).contains(targetId)) continue;
                fixedSrcTarIds.add(Pair.of((Object)depositId, (Object)targetId));
            }
        }
        if (CollectionUtils.isNotEmpty(fixedSrcTarIds)) {
            TmcBotpHelper.batchSaveRelation((String)this.getUpStreamEntity(currentEntity, "fixed"), (String)currentEntity, fixedSrcTarIds);
        }
        if (CollectionUtils.isNotEmpty(noticeSrcTarIds)) {
            TmcBotpHelper.batchSaveRelation((String)this.getUpStreamEntity(currentEntity, "notice"), (String)currentEntity, noticeSrcTarIds);
        }
    }

    private void dealDownBotp(DynamicObject[] dataEntities) {
        Map operationVariable = this.getOperationVariable();
        String operateKey = (String)operationVariable.get("operatekey");
        if (!StringUtils.equals((CharSequence)"audit", (CharSequence)operateKey)) {
            return;
        }
        List<String> depositList = null;
        String depositNos = (String)operationVariable.get("depositnos");
        if (EmptyUtil.isNoEmpty((String)depositNos)) {
            String[] depsositArr = depositNos.split(",");
            depositList = Arrays.asList(depsositArr);
        }
        ArrayList<Pair> srcTarIds = new ArrayList<Pair>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                boolean flag = StringUtils.equals((CharSequence)entry.getString("status"), (CharSequence)"success");
                if (depositList != null) {
                    boolean bl = flag = flag && depositList.contains(entry.getString("loanbillno"));
                }
                if (!flag) continue;
                srcTarIds.add(Pair.of((Object)dataEntity.getLong("id"), (Object)entry.getLong("intbillid")));
            }
        }
        if (CollectionUtils.isNotEmpty(srcTarIds)) {
            String currentEntity = dataEntities[0].getDynamicObjectType().getName();
            TmcBotpHelper.batchSaveRelation((String)currentEntity, (String)this.getDownStreamEntity(currentEntity), srcTarIds);
        }
    }

    private String getUpStreamEntity(String downStreamEntity, String type) {
        String upStreamEntity = "";
        upStreamEntity = StringUtils.equals((CharSequence)"cim_dptrevenuebatch", (CharSequence)downStreamEntity) ? (StringUtils.equals((CharSequence)"notice", (CharSequence)type) ? "cim_noticedeposit" : "cim_deposit") : (StringUtils.equals((CharSequence)"notice", (CharSequence)type) ? "ifm_notice_deposit" : "ifm_deposit");
        return upStreamEntity;
    }

    private String getDownStreamEntity(String upStreamEntity) {
        return StringUtils.equals((CharSequence)"cim_dptrevenuebatch", (CharSequence)upStreamEntity) ? "cim_dptrevenue" : "ifm_dptrevenue";
    }
}

