/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueBatchPushService
extends AbstractTmcBizOppService {
    private List<String> depositNoList;
    private List<DynamicObject> successObjs = new ArrayList<DynamicObject>();
    private List<DynamicObject> failObjs = new ArrayList<DynamicObject>();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("status");
        selector.add("loanbillid");
        selector.add("intcomment");
        selector.add("intdetailnum");
        selector.add("intdetail_tag");
        selector.add("intbillid");
        selector.add("startdate");
        selector.add("actualinstamt");
        selector.add("revenuedate");
        selector.add("loanbillno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject revenueBatch : dataEntities) {
            DynamicObjectCollection entry = revenueBatch.getDynamicObjectCollection("entry");
            List rowList = entry.stream().filter(r -> !"success".equals(r.getString("status"))).collect(Collectors.toList());
            Object[] depositIds = rowList.stream().map(r -> r.getLong("loanbillid")).toArray();
            if (EmptyUtil.isEmpty((Object[])depositIds)) continue;
            this.depositNoList = rowList.stream().map(r -> r.getString("loanbillno")).collect(Collectors.toList());
            DynamicObject[] depositBills = TmcDataServiceHelper.load((Object[])depositIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_deposit"));
            Map<Long, DynamicObject> depositMap = Arrays.stream(depositBills).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
            for (DynamicObject row : rowList) {
                boolean isSuccess = DepositHelper.pushToRevenueAndAudit((DynamicObject)row, depositMap, (Date)revenueBatch.getDate("revenuedate"));
                if (isSuccess) {
                    this.successObjs.add(row);
                    continue;
                }
                this.failObjs.add(row);
            }
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        if (EmptyUtil.isEmpty(this.depositNoList)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("operatekey", "audit");
        option.setVariableValue("depositnos", String.join((CharSequence)",", this.depositNoList));
        TmcOperateServiceHelper.execOperate((String)"bindbotp", (String)dataEntities[0].getDynamicObjectType().getName(), (DynamicObject[])dataEntities, (OperateOption)option);
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (this.getOperationResult().isSuccess()) {
            String message = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"DptRevenueBatchPushService_0", (String)"tmc-cim-business", (Object[])new Object[0]), this.successObjs.size(), this.failObjs.size());
            e.setMessage(message);
            e.setShowMessage(true);
        }
    }
}

