/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.mservice.consistency.bean.CimConsistencyInfo;
import kd.tmc.cim.mservice.consistency.callback.PushCasBillDtxCallback;
import kd.tmc.cim.mservice.consistency.helper.CimConsistencyServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueConfirmService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(DptRevenueConfirmService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("prestenddate");
        selector.add("actpreinstamt");
        selector.add("finorginfo");
        selector.add("bizdate");
        selector.add("predictpreinstamt");
        selector.add("realrate");
        selector.add("inststartdate");
        selector.add("instenddate");
        selector.add("instdays");
        selector.add("instprincipalamt");
        selector.add("rate");
        selector.add("ratetrandays");
        selector.add("instamt");
        selector.add("finorginfo");
        selector.add("loanbillno");
        selector.add("investvarieties");
        selector.add("revenuesort");
        selector.add("recbillno");
        selector.add("combineinst");
        selector.add("isinit");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject revenue : dataEntities) {
            this.writeBackRevenueInfo(revenue);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        try {
            DepositHelper.writeBackDptRevAmt(Arrays.asList(dataEntities), (String)"add");
            this.pushRecInfo(dataEntities);
        }
        catch (Exception e) {
            logger.error("\u6536\u76ca\u5355\u786e\u8ba4\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f{}", (Object)e.getMessage());
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{e.getMessage()});
        }
    }

    private void pushRecInfo(DynamicObject[] dptRevenues) {
        List autoPushBillIds = Arrays.stream(dptRevenues).filter(this::isAutoPush).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(autoPushBillIds)) {
            TmcOperateServiceHelper.execOperate((String)"push2rectransbill", (String)"ifm_dptrevenue", (Object[])autoPushBillIds.toArray(), (OperateOption)OperateOption.create());
            if (DepositHelper.isCimRelateAppSet()) {
                CimConsistencyInfo consistencyInfo = CimConsistencyInfo.build((String)"revenue_asyncPushRec", (String)"revenueBillPushPayService", autoPushBillIds).setCallback((DTXCallback)new PushCasBillDtxCallback());
                consistencyInfo.setCimEntityName("cim_dptrevenue").setIfmEntityName("ifm_dptrevenue");
                CimConsistencyServiceHelper.asyncPush((CimConsistencyInfo)consistencyInfo);
            }
        }
    }

    private boolean isAutoPush(DynamicObject dptRevenue) {
        return DepositHelper.isSettleBill((DynamicObject)dptRevenue) && !dptRevenue.getBoolean("combineinst") && !dptRevenue.getBoolean("isinit");
    }

    private void writeBackRevenueInfo(DynamicObject revenue) {
        revenue.set("confirmstatus", (Object)"yetconfirm");
        DynamicObject dptDealBill = TmcBotpHelper.getTargetBill((String)"cim_dptrevenue", (Object)revenue.getPkValue(), (String)"ifm_bizdealbill_deposit");
        if (EmptyUtil.isEmpty((DynamicObject)dptDealBill)) {
            return;
        }
        revenue.set("bizdate", (Object)dptDealBill.getDate("revenuedate"));
        revenue.set("predictpreinstamt", (Object)dptDealBill.getBigDecimal("predictinstamt"));
        revenue.set("actpreinstamt", (Object)dptDealBill.getBigDecimal("realrevenue"));
        revenue.set("realrate", (Object)dptDealBill.getBigDecimal("revenuerate"));
        revenue.set("prestenddate", (Object)dptDealBill.getDate("prestenddate"));
        DynamicObjectCollection bizDealEntry = dptDealBill.getDynamicObjectCollection("entrys");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)bizDealEntry)) {
            return;
        }
        DynamicObjectCollection entry = revenue.getDynamicObjectCollection("entrys");
        entry.clear();
        for (DynamicObject row : bizDealEntry) {
            DynamicObject newRow = entry.addNew();
            newRow.set("inststartdate", (Object)row.getDate("estartdate"));
            newRow.set("instenddate", (Object)row.getDate("eenddate"));
            newRow.set("instdays", (Object)row.getInt("edays"));
            newRow.set("instprincipalamt", (Object)row.getBigDecimal("efinamount"));
            newRow.set("rate", (Object)row.getBigDecimal("eplanrevenue"));
            newRow.set("ratetrandays", (Object)row.getInt("econvertdays"));
            newRow.set("instamt", (Object)row.getBigDecimal("erevenueamount"));
        }
    }
}

