/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DptRevenueDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loanbillno");
        selector.add("investvarieties");
        selector.add("finorginfo");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List dtpBillNos = Arrays.stream(dataEntities).map(v -> v.getString("loanbillno")).collect(Collectors.toList());
        DynamicObject[] dptBills = TmcDataServiceHelper.load((String)"cim_deposit", (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", dtpBillNos)});
        Map dptBillMap = Arrays.stream(dptBills).collect(Collectors.toMap(v -> v.getString("billno"), r -> r, (o1, o2) -> o1, HashMap::new));
        for (DynamicObject revenue : dataEntities) {
            String dtpBillNo = revenue.getString("loanbillno");
            DynamicObject dtpBill = (DynamicObject)dptBillMap.get(dtpBillNo);
            if (EmptyUtil.isEmpty((DynamicObject)dtpBill)) continue;
            Pair otherSideBotpPair = DepositHelper.getOtherSideBotpPair((DynamicObject)revenue);
            TmcBotpHelper.deleteRation((String)((String)otherSideBotpPair.getRight()), (Long)dtpBill.getLong("id"), (Long[])new Long[]{revenue.getLong("id")});
        }
    }
}

