/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DptRevenueSaveOtherSideBotpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loanbillno");
        selector.add("investvarieties");
        selector.add("finorginfo");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            this.buildOtherSideBotp(dataEntity);
        }
    }

    private void buildOtherSideBotp(DynamicObject revenueBill) {
        String dptBillNo = revenueBill.getString("loanbillno");
        boolean settleBill = DepositHelper.isSettleBill((DynamicObject)revenueBill);
        if (EmptyUtil.isEmpty((String)dptBillNo) || !settleBill) {
            return;
        }
        DynamicObject dptBill = TmcDataServiceHelper.loadSingleFromCache((String)"cim_deposit", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)dptBillNo)});
        Pair otherSideBotpPair = DepositHelper.getOtherSideBotpPair((DynamicObject)revenueBill);
        TmcBotpHelper.saveRelation((String)((String)otherSideBotpPair.getLeft()), (Long)dptBill.getLong("id"), (String)((String)otherSideBotpPair.getRight()), (Long)revenueBill.getLong("id"));
    }
}

