/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;

public class CurrentToFixedDataSource
implements IEBRequestDataSource {
    private final DynamicObject depositBill;

    public CurrentToFixedDataSource(DynamicObject depositBill) {
        this.depositBill = depositBill;
    }

    public List<DepositDetail> getDetail() {
        ArrayList<DepositDetail> details = new ArrayList<DepositDetail>();
        DepositDetail detail = new DepositDetail();
        detail.setDetailSeqID(this.depositBill.getPkValue().toString());
        detail.setBatchSeqID(this.depositBill.getPkValue().toString());
        detail.setDetailBizNo(this.depositBill.getString("billno"));
        detail.setAccNo(this.getAcctNo());
        detail.setAmount(this.depositBill.getBigDecimal("amount").setScale(6, RoundingMode.HALF_UP).toString());
        detail.setInftyp(this.depositBill.getString("prenoticeday"));
        DynamicObject settleAccount = this.depositBill.getDynamicObject("settleaccount");
        detail.setAccName(settleAccount.getString("acctname"));
        DynamicObject finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)settleAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo", (String)"union_number,name");
        detail.setAcntBank(finOrg.getString("name"));
        detail.setAcntBankNo(finOrg.getString("union_number"));
        DynamicObject account = this.depositBill.getDynamicObject("finaccountf7");
        String finAccount = this.depositBill.getString("finaccount");
        if (EmptyUtil.isNoEmpty((DynamicObject)account) && account.getString("bankaccountnumber").equals(finAccount)) {
            detail.setFixedAccName(account.getString("acctname"));
            finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)account.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo", (String)"union_number,name");
            detail.setFixedAcntBank(finOrg.getString("name"));
            detail.setFixedAcntBankNo(finOrg.getString("union_number"));
        } else {
            detail.setFixedAccName("");
            detail.setFixedAcntBank("");
            detail.setFixedAcntBankNo("");
        }
        detail.setFixedAccNo(finAccount);
        detail.setDepositTermValue(this.depositBill.getString("deadline"));
        detail.setNextDepositType(ExpireRedepositTypeEnum.getEbStatusByValue((String)this.depositBill.getString("expireredeposit")));
        detail.setCurrency(this.depositBill.getDynamicObject("currency").getString("number"));
        detail.setExplanation(this.depositBill.getString("explain"));
        details.add(detail);
        return details;
    }

    @Override
    public PayStatusBody getUpdateBody() {
        return null;
    }

    @Override
    public String getAcctNo() {
        return this.depositBill.getDynamicObject("settleaccount").getString("bankaccountnumber");
    }

    @Override
    public String getCurrency() {
        return this.depositBill.getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.depositBill.getPkValue().toString();
    }

    @Override
    public String getBatchBizNo() {
        return this.depositBill.getString("billno");
    }

    @Override
    public String getExtData() {
        return null;
    }
}

