/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;

public class NoticeToCurrentDataSource
implements IEBRequestDataSource {
    private final DynamicObject depositBill;

    public NoticeToCurrentDataSource(DynamicObject depositBill) {
        this.depositBill = depositBill;
    }

    public List<DepositDetail> getDetail() {
        ArrayList<DepositDetail> details = new ArrayList<DepositDetail>();
        DepositDetail detail = new DepositDetail();
        detail.setDetailSeqID(this.depositBill.getPkValue().toString());
        detail.setBatchSeqID(this.depositBill.getPkValue().toString());
        detail.setDetailBizNo(this.depositBill.getString("billno"));
        detail.setAccNo(this.getAcctNo());
        detail.setAmount(this.depositBill.getBigDecimal("amount").setScale(6, RoundingMode.HALF_UP).toString());
        detail.setInftyp(this.depositBill.getDynamicObject("finbillno").getString("prenoticeday"));
        DynamicObject account = this.depositBill.getDynamicObject("finaccountf7");
        account = TmcDataServiceHelper.loadSingleFromCache((Object)account.getPkValue(), (String)"bd_accountbanks", (String)"id,acctname,name,bank");
        detail.setAccName(account.getString("acctname"));
        DynamicObject finOrg = TmcDataServiceHelper.loadSingle((Object)account.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo", (String)"union_number,name");
        detail.setAcntBank(finOrg.getString("name"));
        detail.setAcntBankNo(finOrg.getString("union_number"));
        String finAccountStr = this.depositBill.getDynamicObject("finbillno").getString("finaccount");
        if (EmptyUtil.isNoEmpty((String)finAccountStr)) {
            QFilter qFilter = new QFilter("bankaccountnumber", "=", (Object)finAccountStr);
            DynamicObject finAccount = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,acctname,name,bank", (QFilter[])qFilter.toArray());
            detail.setFixedAccNo(finAccountStr);
            if (EmptyUtil.isNoEmpty((DynamicObject)finAccount)) {
                detail.setFixedAccName(finAccount.getString("acctname"));
                finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)finAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo", (String)"union_number,name");
                detail.setFixedAcntBank(finOrg.getString("name"));
                detail.setFixedAcntBankNo(finOrg.getString("union_number"));
            }
        }
        detail.setCurrency(this.depositBill.getDynamicObject("currency").getString("number"));
        detail.setReqNbr(this.depositBill.getDynamicObject("finbillno").getString("reqnbr"));
        details.add(detail);
        return details;
    }

    @Override
    public PayStatusBody getUpdateBody() {
        return null;
    }

    @Override
    public String getAcctNo() {
        return this.depositBill.getDynamicObject("finaccountf7").getString("bankaccountnumber");
    }

    @Override
    public String getCurrency() {
        return this.depositBill.getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.depositBill.getPkValue().toString();
    }

    @Override
    public String getBatchBizNo() {
        return this.depositBill.getString("billno");
    }

    @Override
    public String getExtData() {
        return null;
    }
}

