/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.finsubscribe;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.finsubscribe.FinsubscribeDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;

public class FinSubscribeDataSource
implements IEBRequestDataSource {
    private final DynamicObject finSubscribeBill;

    public FinSubscribeDataSource(DynamicObject finSubscribeBill) {
        this.finSubscribeBill = finSubscribeBill;
    }

    public List<FinsubscribeDetail> getDetail() {
        ArrayList<FinsubscribeDetail> details = new ArrayList<FinsubscribeDetail>();
        FinsubscribeDetail detail = new FinsubscribeDetail();
        detail.setDetailSeqID(this.finSubscribeBill.getPkValue().toString());
        detail.setDetailBizNo(this.getBatchBizNo());
        detail.setBatchSeqId(this.getBatchSeqId());
        detail.setAccNo(this.getAcctNo());
        detail.setProductCode(this.finSubscribeBill.getString("productno"));
        detail.setCurrency(this.finSubscribeBill.getDynamicObject("currency").getString("number"));
        String redeemWay = this.finSubscribeBill.getString("redeemway");
        detail.setRedeemWay(redeemWay);
        detail.setAmount(this.getAmount());
        detail.setNumber(this.finSubscribeBill.getString("buycopies"));
        detail.setPrice(this.finSubscribeBill.getBigDecimal("iopv").toString());
        if (EmptyUtil.isNoEmpty((Object)this.finSubscribeBill.getDate("expiredate"))) {
            detail.setRollDate(TermHelper.getDiffDays((Date)this.finSubscribeBill.getDate("valuedate"), (Date)this.finSubscribeBill.getDate("expiredate")) + "");
            detail.setEndDate(DateUtils.formatString((Date)this.finSubscribeBill.getDate("expiredate"), (String)"yyyy-MM-dd"));
        }
        detail.setFollFlag(this.getFollFlag(this.finSubscribeBill));
        detail.setCshDraFlag(this.getCshDraFlag());
        detail.setStartDate(DateUtils.formatString((Date)this.finSubscribeBill.getDate("valuedate"), (String)"yyyy-MM-dd"));
        details.add(detail);
        return details;
    }

    private String getCshDraFlag() {
        String cshDraFlag = "";
        String bankCateNumber = this.getBankCateNumber();
        if ("BC-0031".equals(bankCateNumber)) {
            cshDraFlag = "N";
        } else if ("BC-0024".equals(bankCateNumber)) {
            cshDraFlag = "0";
        }
        return cshDraFlag;
    }

    private String getAmount() {
        String bankCateNumber = this.getBankCateNumber();
        if ("BC-0031".equals(bankCateNumber)) {
            return this.finSubscribeBill.getBigDecimal("amount").setScale(0, 1).toString();
        }
        if ("BC-0024".equals(bankCateNumber)) {
            return this.finSubscribeBill.getBigDecimal("amount").setScale(2, 1).toString();
        }
        return this.finSubscribeBill.getBigDecimal("amount").toString();
    }

    private String getBankCateNumber() {
        DynamicObject settleAccount = this.finSubscribeBill.getDynamicObject("settleaccount");
        DynamicObject finAccount = TmcDataServiceHelper.loadSingleFromCache((Object)settleAccount.getPkValue(), (String)"bd_accountbanks", (String)"id,acctname,name,bank");
        DynamicObject finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)finAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo", (String)"bank_cate");
        return finOrg.getString("bank_cate.number");
    }

    private String getFollFlag(DynamicObject finSubscribeBill) {
        String expirereDeposit = finSubscribeBill.getString("expireredeposit");
        if (ExpireRedepositTypeEnum.NOREDEPOSIT.getValue().equals(expirereDeposit)) {
            return "2";
        }
        return "1";
    }

    @Override
    public PayStatusBody getUpdateBody() {
        return null;
    }

    @Override
    public String getAcctNo() {
        return this.finSubscribeBill.getDynamicObject("settleaccount").getString("bankaccountnumber");
    }

    @Override
    public String getCurrency() {
        return this.finSubscribeBill.getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.finSubscribeBill.getPkValue().toString();
    }

    @Override
    public String getBatchBizNo() {
        return this.finSubscribeBill.getString("billno");
    }

    @Override
    public String getExtData() {
        return null;
    }
}

