/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.finsubscribe;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.finsubscribe.FinsubscribeDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusDetail;

public class FinSubscribeUpdateStatusDataSource
implements IEBRequestDataSource {
    private final DynamicObject bussBill;
    private final String reason;

    public FinSubscribeUpdateStatusDataSource(DynamicObject bussBill, String reason) {
        this.reason = reason;
        this.bussBill = bussBill;
    }

    @Override
    public PayStatusBody getUpdateBody() {
        PayStatusBody body = new PayStatusBody();
        body.setTotalCount(1);
        ArrayList<PayStatusDetail> details = new ArrayList<PayStatusDetail>(10);
        PayStatusDetail detail = new PayStatusDetail();
        detail.setDetailSeqID(this.bussBill.getPkValue().toString());
        detail.setBatchSeqID(this.bussBill.getPkValue().toString());
        detail.setModifyStatus(BeBillStatusEnum.TS.getValue().equals(this.bussBill.getString("bebankstatus")) ? 12 : 13);
        detail.setUpdateReason(this.reason);
        detail.setOperator(RequestContext.get().getUserName());
        details.add(detail);
        body.setDetails(details);
        return body;
    }

    public List<FinsubscribeDetail> getDetail() {
        return null;
    }

    @Override
    public String getAcctNo() {
        String entity;
        String accountNo = null;
        switch (entity = this.bussBill.getDynamicObjectType().getName()) {
            case "cim_finsubscribe": {
                accountNo = this.bussBill.getDynamicObject("settleaccount").getString("bankaccountnumber");
                break;
            }
            case "cim_redeem": {
                accountNo = EmptyUtil.isEmpty((DynamicObject)this.bussBill.getDynamicObject("recaccountf7")) ? this.bussBill.getString("recaccount") : this.bussBill.getDynamicObject("recaccountf7").getString("bankaccountnumber");
            }
        }
        return accountNo;
    }

    @Override
    public String getCurrency() {
        return this.bussBill.getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.bussBill.getPkValue().toString();
    }

    @Override
    public String getBatchBizNo() {
        return this.bussBill.getString("billno");
    }

    @Override
    public String getExtData() {
        return null;
    }
}

