/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.finsubscribe;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.bussiness.opservice.ebservice.request.FinSubscribeUpdateRequestBuilder;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.finsubscribe.FinSubscribeUpdateStatusDataSource;
import kd.tmc.cim.common.helper.FinSubscribeHelper;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.finsubscribe.FinsubscribeBody;

public class FinSubscribeUpdateStatusService
implements IEBService<EBResult> {
    private EBResult ebResult;
    private final DynamicObject bussBill;
    private final String reason;

    public FinSubscribeUpdateStatusService(DynamicObject bussBill, String reason) {
        this.reason = reason;
        this.bussBill = bussBill;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(this.getBankBillId());
    }

    public void handleEBException(String body, String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(this.getBankBillId());
        if (e instanceof EBBizNCException) {
            this.ebResult.setErrCode(((EBBizNCException)e).getErrorCode());
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.bussBill.set("bebankstatus", (Object)BeBillStatusEnum.NC.getValue());
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bussBill});
            }
            catch (Exception ee) {
                tx.markRollback();
                throw ee;
            }
        }
    }

    public void handleResultBody(String resultBody) {
        FinsubscribeBody result = (FinsubscribeBody)JSON.parseObject((String)resultBody, FinsubscribeBody.class);
        List details = result.getDetails();
        if (details == null || details.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u65f6\uff0c\u94f6\u4f01\u8fd4\u56de\u7684\u660e\u7ec6\u4e3a\u7a7a\u3002\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u83b7\u53d6\u8be6\u60c5\u3002", (String)"UpdateStatusService_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        if ("cim_finsubscribe".equals(this.getEntityName())) {
            this.ebResult = FinSubscribeHelper.dealResponseResult((List)details, (DynamicObject)this.bussBill, (boolean)true);
        } else if ("cim_redeem".equals(this.getEntityName())) {
            this.ebResult = RedeemBillHelper.dealResponseResult((List)details, (DynamicObject)this.bussBill, (boolean)true);
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        FinSubscribeUpdateStatusDataSource dataSource = new FinSubscribeUpdateStatusDataSource(this.bussBill, this.reason);
        return new FinSubscribeUpdateRequestBuilder("updateFinancingStatus", dataSource);
    }

    public String getEntityName() {
        return this.bussBill.getDataEntityType().getName();
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.bussBill.getLong("id")));
        logInfo.setBillNo(this.bussBill.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.bussBill.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public EBResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        return FinSubscribeHelper.getBankCateId((DynamicObject)this.bussBill, (String)this.getEntityName());
    }

    private Long getBankBillId() {
        return (Long)this.bussBill.getPkValue();
    }
}

