/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.supermarket;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cim.bussiness.opservice.ebservice.service.supermarket.PrdCardService;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CmbPrdCardServiceImpl
implements PrdCardService {
    @Override
    public void execute(JSONObject row, Pair<DynamicObject, DynamicObject> marketPair, Map<String, Long> currencyMap) {
        DynamicObject marketBill = (DynamicObject)marketPair.getLeft();
        DynamicObject prdCardBill = (DynamicObject)marketPair.getRight();
        prdCardBill.set("number", (Object)row.getString("productCode"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"currency", (Object)currencyMap.get(row.getString("currency")));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"cmb_listdate", (Object)row.getDate("publishStartDate"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"cmb_untilldate", (Object)row.getDate("publishEndDate"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"cmb_price", (Object)row.getBigDecimal("buyPrice"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"cmb_redeemceil", (Object)row.getBigDecimal("redeemMax"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"cmb_redeemfloor", (Object)row.getBigDecimal("redeemMin"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"cmb_risklevel", (Object)row.getString("riskLev"));
        String bankFields = row.getString("bankFields");
        List fieldList = JSONObject.parseArray((String)bankFields, JSONObject.class);
        for (int j = 0; j < fieldList.size(); ++j) {
            JSONObject r = (JSONObject)fieldList.get(j);
            String bankField = r.getString("key");
            String cardField = SuperMarketHelper.turnBankFieldToCard((String)bankField, (String)"maacod,redctl,purctl,sbsctl,bnsctl,navdat,tercod,prfrat,terday,riptyp,qtybas,qtyhig,qtylow,sbsbdt,sbsedt,sbsprc,purbdt,puredt,redbdt,rededt,bnscnt,bnsamt,bnsqty", (String)"cmb_agency,cmb_redeemcontrol,cmb_subcontrol,cmb_applycontrol,cmb_bonuscontrol,cmb_pricedate,cmb_subscribemark,planrevenue,cmb_prdlimitinfo,cmb_prdtype,cmb_copybase,cmb_subamtceil,cmb_subamtfloor,cmb_applystartdate,cmb_applyenddate,cmb_applyprice,cmb_substartdate,cmb_subenddate,cmb_redeemstartdate,cmb_redeemenddate,cmb_bonuscount,cmb_bonusamt,cmb_bonuscopy");
            if (EmptyUtil.isNoEmpty((String)cardField) && cardField.startsWith("cmb_")) {
                Object value = r.get((Object)"value");
                if (SuperMarketHelper.isTurnToBoolean((String)bankField)) {
                    value = EmptyUtil.isEmpty((Object)value) || StringUtils.equals((CharSequence)"Y", (CharSequence)value.toString()) ? Boolean.TRUE : Boolean.FALSE;
                } else if (SuperMarketHelper.isTurnToDate((String)bankField, (String)"navdat,sbsbdt,sbsedt,purbdt,puredt,redbdt,rededt") && EmptyUtil.isNoEmpty((Object)value)) {
                    value = SuperMarketHelper.getFormatDate((String)value.toString());
                }
                SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)cardField, (Object)value);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"prfrat", (CharSequence)bankField)) continue;
            BigDecimal planRevenue = r.getBigDecimal("value");
            String planRevenueStr = EmptyUtil.isEmpty((BigDecimal)planRevenue) ? "" : SuperMarketHelper.tripBigDecimalZero((BigDecimal)planRevenue.multiply(new BigDecimal("100")));
            SuperMarketHelper.setValueWhenNotNull((DynamicObject)marketBill, (String)"planrevenue", (Object)planRevenueStr);
        }
    }
}

