/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.finsubscribe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.FinBizStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubScribeDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourbillno");
        selector.add("id");
        selector.add("billno");
        selector.add("isresubmit");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> finApplys = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject finSubscribe : dataEntities) {
            DynamicObject finApply = TmcBotpHelper.getSourceBill((String)"cim_finsubscribe", (Object)finSubscribe.getPkValue(), (String)"cim_finapply");
            if (!EmptyUtil.isNoEmpty((DynamicObject)finApply)) continue;
            finApplys.add(finApply);
        }
        if (EmptyUtil.isNoEmpty(finApplys)) {
            this.writeBackFinApply(finApplys);
        }
        this.writeBackFinSubscribe(dataEntities);
    }

    private void writeBackFinSubscribe(DynamicObject[] dataEntities) {
        Object[] srcFinNos = Arrays.stream(dataEntities).map(v -> v.getString("sourbillno")).toArray();
        if (EmptyUtil.isEmpty((Object[])srcFinNos)) {
            return;
        }
        DynamicObject[] srcFins = TmcDataServiceHelper.load((String)"cim_finsubscribe", (String)"id,sourbillno,billno,isresubmit", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)srcFinNos)});
        Map<String, DynamicObject> srcFinMap = Arrays.stream(srcFins).collect(Collectors.toMap(v -> v.getString("billno"), o -> o));
        ArrayList<DynamicObject> srcFinList = new ArrayList<DynamicObject>(srcFins.length);
        for (DynamicObject finBill : dataEntities) {
            DynamicObject sourcebill;
            String srcFinNo = finBill.getString("sourbillno");
            DynamicObject srcFinBill = srcFinMap.get(srcFinNo);
            if (EmptyUtil.isEmpty((DynamicObject)srcFinBill)) continue;
            srcFinBill.set("isresubmit", (Object)false);
            srcFinList.add(srcFinBill);
            String sourcebillNo = srcFinBill.getString("sourbillno");
            if (!EmptyUtil.isNoEmpty((String)sourcebillNo) || !EmptyUtil.isNoEmpty((DynamicObject)(sourcebill = TmcDataServiceHelper.loadSingle((String)"cim_finsubscribe", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)sourcebillNo)})))) continue;
            TmcBotpHelper.deleteRation((String)"cim_finsubscribe", (Long)((Long)sourcebill.getPkValue()), (Long)finBill.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])srcFinList.toArray(new DynamicObject[0]));
    }

    private void writeBackFinApply(List<DynamicObject> finApplys) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(finApplys.size());
        for (DynamicObject finApply : finApplys) {
            QFilter qFilter = new QFilter("id", "!=", (Object)finApply.getLong("id"));
            Object[] targetBills = TmcBotpHelper.getTargetBills((String)"cim_finapply", (Object)finApply.getPkValue(), (String)"cim_finsubscribe", (QFilter)qFilter);
            if (!EmptyUtil.isEmpty((Object[])targetBills)) continue;
            finApply.set("issubscribe", (Object)false);
            finApply.set("finservicestatus", (Object)FinBizStatusEnum.UNHANDLE.getValue());
            updateList.add(finApply);
        }
        if (EmptyUtil.isNoEmpty(updateList)) {
            TmcDataServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
    }
}

