/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.finsubscribe;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("finservicestatus");
        sic.add("sourbillno");
        sic.add("amount");
        sic.add("isrenewal");
        sic.add("tradechannel");
        sic.add("valuedate");
        sic.add("isinit");
        sic.add("redeemamount");
        sic.add("redeemcopies");
        sic.add("buycopies");
        sic.add("redeemway");
        sic.add("currency.id");
        sic.add("org.id");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> applys = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject finSubscribe : dataEntities) {
            DynamicObject sourceApply;
            BigDecimal amount = finSubscribe.getBigDecimal("amount");
            String tradeChannel = finSubscribe.getString("tradechannel");
            if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel) && !finSubscribe.getBoolean("isrenewal")) {
                finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_ing.getValue());
                continue;
            }
            finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_done.getValue());
            BigDecimal redeemAmt = finSubscribe.getBigDecimal("redeemamount");
            BigDecimal redeemCopy = finSubscribe.getBigDecimal("redeemcopies");
            if (finSubscribe.getBoolean("isinit") && (EmptyUtil.isNoEmpty((BigDecimal)redeemAmt) || EmptyUtil.isNoEmpty((BigDecimal)redeemCopy))) {
                String redeemWay = finSubscribe.getString("redeemway");
                boolean endFlag = RedeemWayEnum.isAmountRedeem((String)redeemWay) && redeemAmt.compareTo(amount) >= 0 || RedeemWayEnum.isCopiesRedeem((String)redeemWay) && redeemCopy.compareTo(finSubscribe.getBigDecimal("buycopies")) >= 0;
                String bizStatus = endFlag ? FinServiceStatusEnum.subscribe_end.getValue() : FinServiceStatusEnum.subscribe_part.getValue();
                finSubscribe.set("finservicestatus", (Object)bizStatus);
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(sourceApply = TmcBotpHelper.getSourceBill((String)"cim_finsubscribe", (Object)finSubscribe.getPkValue(), (String)"cim_finapply"))) || finSubscribe.getBoolean("isrenewal")) continue;
            BigDecimal oldAddAmount = sourceApply.getBigDecimal("addamount");
            BigDecimal addAmount = oldAddAmount.add(amount);
            sourceApply.set("addamount", (Object)addAmount);
            BigDecimal lastAmount = sourceApply.getBigDecimal("amount").subtract(addAmount);
            sourceApply.set("lastamount", (Object)lastAmount);
            applys.add(sourceApply);
        }
        TmcDataServiceHelper.save((DynamicObject[])applys.toArray(new DynamicObject[0]));
    }
}

