/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.finsubscribe;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.cim.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class FinSubscribeRevePlanSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject finSubBill : dynamicObjects) {
            this.updateReveEntrys(finSubBill);
        }
    }

    private void updateReveEntrys(DynamicObject finSubBill) {
        if (!finSubBill.getBoolean("handreveplan")) {
            return;
        }
        DynamicObjectCollection entrys = finSubBill.getDynamicObjectCollection("revenue_entry");
        Map<Date, BigDecimal> changeEntryMap = this.getChangeEntryMap(entrys);
        if (changeEntryMap.isEmpty()) {
            return;
        }
        Pair<BigDecimal, List<IntBillInfo>> intBills = this.callIntPlanByHand(finSubBill);
        if (intBills == null) {
            return;
        }
        List intBillInfos = (List)intBills.getValue();
        if (EmptyUtil.isEmpty((Collection)intBillInfos)) {
            return;
        }
        Map<Date, DynamicObject> entryMap = entrys.stream().collect(Collectors.toMap(i -> i.getDate("revenuedate"), i -> i));
        for (IntBillInfo intBill : intBillInfos) {
            IntBillDetailInfo info;
            BigDecimal amount;
            Date revenueDate = intBill.getBizDate();
            DynamicObject reveEntry = entryMap.get(revenueDate);
            if (reveEntry != null) {
                intBill.setAmount(reveEntry.getBigDecimal("revenuecalamount"));
                intBill.setRemark(reveEntry.getString("revenueremark"));
            }
            if ((amount = changeEntryMap.get(revenueDate)) == null) continue;
            List details = intBill.getDetails();
            if (EmptyUtil.isNoEmpty((Object)details)) {
                info = (IntBillDetailInfo)details.get(0);
            } else {
                info = new IntBillDetailInfo();
                info.setPrinciple(finSubBill.getBigDecimal("amount"));
                info.setIntType(InterTypeEnum.normal);
                info.setAmount(intBill.getAmount());
            }
            info.setBeginDate(intBill.getBeginDate());
            info.setEndDate(intBill.getEndDate());
            info.setDays(DateUtils.getDiffDays((Date)intBill.getBeginDate(), (Date)intBill.getEndDate()));
            details.clear();
            details.add(info);
        }
        RevenuePlanCalHelper.finBillWriteBack(intBills, (DynamicObject)finSubBill);
    }

    private Map<Date, BigDecimal> getChangeEntryMap(DynamicObjectCollection entrys) {
        HashMap<Date, BigDecimal> entryAmountMap = new HashMap<Date, BigDecimal>(8);
        for (DynamicObject entry : entrys) {
            Date revenueDate = entry.getDate("revenuedate");
            DynamicObjectCollection subEntry = entry.getDynamicObjectCollection("revenue_subentry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)subEntry)) {
                entryAmountMap.put(revenueDate, BigDecimal.ZERO);
                continue;
            }
            BigDecimal reveCalAmount = entry.getBigDecimal("revenuecalamount");
            BigDecimal amount = subEntry.stream().map(e -> e.getBigDecimal("finamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (amount.compareTo(reveCalAmount) == 0) continue;
            entryAmountMap.put(revenueDate, amount);
        }
        return entryAmountMap;
    }

    private Pair<BigDecimal, List<IntBillInfo>> callIntPlanByHand(DynamicObject finSubBill) {
        DynamicObjectCollection entrys = finSubBill.getDynamicObjectCollection("revenue_entry");
        ArrayList<PlanCallResult> intPlanList = new ArrayList<PlanCallResult>(entrys.size());
        for (DynamicObject entry : entrys) {
            if (entry.getInt("revenuestate") == 1) continue;
            PlanCallResult callResult = new PlanCallResult();
            callResult.setBizDate(entry.getDate("revenuedate"));
            intPlanList.add(callResult);
        }
        return RevenueCalcHelper.callIntPlanByHand((DynamicObject)finSubBill, intPlanList);
    }
}

