/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.finsubscribe;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.bussiness.opservice.ebservice.api.EBServiceFacadeImpl;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;

public class FinUpdateStatusAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcetype");
        sic.add("sourcebillid");
        sic.add("entrys");
        sic.add("entrys.statusnew");
        sic.add("entrys.bebankstatus");
        sic.add("entrys.reason");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> finSubscribeList = new ArrayList<DynamicObject>(dataEntities.length);
        EBServiceFacadeImpl ebServiceFacade = new EBServiceFacadeImpl();
        for (DynamicObject dataEntity : dataEntities) {
            String sourceType = dataEntity.getString("sourcetype");
            Long sourceId = dataEntity.getLong("sourcebillid");
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entrys");
            DynamicObject entry = (DynamicObject)entrys.get(0);
            String reason = entry.getString("reason");
            DynamicObject sourceBill = TmcDataServiceHelper.loadSingle((Object)sourceId, (String)sourceType);
            sourceBill.set("isupdatingstatus", (Object)"0");
            sourceBill.set("lastmodifier", (Object)RequestContext.get().getCurrUserId());
            sourceBill.set("lastmodifytime", (Object)new Date());
            List<EBResult> result = ebServiceFacade.updateStatus("finsubscribe", reason, sourceBill);
            List errList = result.stream().filter(o -> o.getStatusCode() == EBResultStatusCode.ERROR || o.getStatusCode() == EBResultStatusCode.ROLLBACK).collect(Collectors.toList());
            StringBuilder errMsg = new StringBuilder();
            for (EBResult errResult : errList) {
                errMsg.append(errResult.getErrMsg()).append(' ');
            }
            if (errMsg.length() > 0) {
                throw new KDBizException(errMsg.toString());
            }
            finSubscribeList.add(sourceBill);
        }
        SaveServiceHelper.save((DynamicObject[])finSubscribeList.toArray(new DynamicObject[finSubscribeList.size()]));
    }
}

