/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.cim.common.helper.FinSubscribeInitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeInitAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("handrevenueamt");
        selector.add("handredeemamt");
        selector.add("handredeemcopies");
        selector.add("endinstdate");
        selector.add("redeemamount");
        selector.add("redeemcopies");
        selector.add("totalamount");
        selector.add("totalcopies");
        selector.add("handiopv");
        selector.add("buycopies");
        selector.add("amount");
        selector.add("handlastredeemdate");
        selector.add("handlastrevenuedate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject finsubBill : dataEntities) {
            finsubBill.set("endinstdate", null);
            finsubBill.set("redeemamount", null);
            finsubBill.set("redeemcopies", null);
            finsubBill.set("totalamount", null);
            finsubBill.set("totalcopies", null);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        Map<Long, DynamicObject> finsubMap = Arrays.stream(dataEntities).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
        this.produceRedeemBill(dataEntities, finsubMap);
        this.produceRevenueBill(dataEntities, finsubMap);
        BusinessHelper.addAttachments((DynamicObject[])dataEntities, (String)"cim_finsubscribe");
    }

    private void produceRevenueBill(DynamicObject[] dataEntities, Map<Long, DynamicObject> finsubMap) {
        DynamicObject[] revenueBills;
        Object[] ids = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handrevenueamt"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return;
        }
        for (DynamicObject revenueBill : revenueBills = TmcBotpHelper.batchPush((Object[])ids, (String)"cim_finsubscribe", (String)"cim_revenue")) {
            DynamicObject finsubBill = finsubMap.get(revenueBill.getLong("finbillno_id"));
            FinSubscribeInitHelper.setRevenueInitBill((DynamicObject)revenueBill, (DynamicObject)finsubBill);
            OperateOption option = OperateOption.create();
            option.setVariableValue("WF", "TRUE");
            OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"cim_revenue", (DynamicObject[])new DynamicObject[]{revenueBill}, (OperateOption)option);
            if (!EmptyUtil.isNoEmpty((Object)submitResult)) continue;
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"cim_revenue", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        }
    }

    private void produceRedeemBill(DynamicObject[] dataEntities, Map<Long, DynamicObject> finsubMap) {
        DynamicObject[] redeemBills;
        Object[] ids = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handredeemamt")) || EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handredeemcopies"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return;
        }
        for (DynamicObject redeemBill : redeemBills = TmcBotpHelper.batchPush((Object[])ids, (String)"cim_finsubscribe", (String)"cim_redeem")) {
            DynamicObject finsubBill = finsubMap.get(redeemBill.getLong("sourcebillid"));
            FinSubscribeInitHelper.setRedeemInitBill((DynamicObject)redeemBill, (DynamicObject)finsubBill, (Date)finsubBill.getDate("handlastredeemdate"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("WF", "TRUE");
            OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"cim_redeem", (DynamicObject[])new DynamicObject[]{redeemBill}, (OperateOption)option);
            if (!EmptyUtil.isNoEmpty((Object)submitResult)) continue;
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"cim_redeem", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        }
    }
}

