/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.helper.FinSubscribeInitHelper;
import kd.tmc.cim.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeInitHistoryUpdateService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("handrevenueamt");
        selector.add("handredeemamt");
        selector.add("handlastrevenuedate");
        selector.add("redeemway");
        selector.add("intdate");
        selector.add("valuedate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.dealInitRedeemBill(dataEntities);
        this.dealInitRevenueBill(dataEntities);
    }

    /*
     * WARNING - void declaration
     */
    private void dealInitRevenueBill(DynamicObject[] dataEntities) {
        DynamicObject[] dbRevenueBills;
        void var7_9;
        DynamicObject[] revenueBills;
        Object[] needRevenueIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handrevenueamt"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])needRevenueIds)) {
            return;
        }
        Map<Long, DynamicObject> finsubMap = Arrays.stream(dataEntities).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
        DynamicObject[] dynamicObjectArray = revenueBills = TmcBotpHelper.batchPush((Object[])needRevenueIds, (String)"cim_finsubscribe", (String)"cim_revenue");
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            DynamicObject revenueBill = dynamicObjectArray[var7_9];
            DynamicObject finsubBill = finsubMap.get(revenueBill.getLong("finbillno_id"));
            FinSubscribeInitHelper.setRevenueInitBill((DynamicObject)revenueBill, (DynamicObject)finsubBill);
            String string = finsubBill.getString("redeemway");
            Date startDate = RedeemWayEnum.isAmountRedeem((String)string) ? finsubBill.getDate("intdate") : finsubBill.getDate("valuedate");
            revenueBill.set("revenuestartdate", (Object)startDate);
            ++var7_9;
        }
        OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"cim_revenue", (DynamicObject[])revenueBills, (OperateOption)OperateOption.create());
        for (DynamicObject dynamicObject : dbRevenueBills = TmcDataServiceHelper.load((String)"cim_revenue", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)saveResult.getSuccessPkIds())})) {
            dynamicObject.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dbRevenueBills);
        for (Object object : needRevenueIds) {
            RevenuePlanCalHelper.calRevenuePlan((Long)((Long)object), (String)CimEntityEnum.cim_revenue.getValue(), (Map)this.operationVariable);
        }
    }

    private void dealInitRedeemBill(DynamicObject[] dataEntities) {
        DynamicObject[] finsubBills;
        Object[] needReleaseIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handredeemamt"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])needReleaseIds)) {
            return;
        }
        for (DynamicObject finBill : finsubBills = TmcDataServiceHelper.load((Object[])needReleaseIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_finsubscribe"))) {
            this.produceReleaseBill(finBill);
        }
    }

    private void produceReleaseBill(DynamicObject finBill) {
        DynamicObject[] dbRedeemBills;
        Date lastRedeemDate;
        DynamicObject[] releaseBills = TmcBotpHelper.push((DynamicObject)finBill, (String)"cim_redeem");
        DynamicObject releaseBill = releaseBills[0];
        String redeemWay = finBill.getString("redeemway");
        if (RedeemWayEnum.isAmountRedeem((String)redeemWay)) {
            Date lastRevenueDate = finBill.getDate("handlastrevenuedate");
            lastRedeemDate = DateUtils.getNextDay((Date)lastRevenueDate, (int)1);
        } else {
            lastRedeemDate = finBill.getDate("valuedate");
        }
        FinSubscribeInitHelper.setRedeemInitBill((DynamicObject)releaseBill, (DynamicObject)finBill, (Date)lastRedeemDate);
        releaseBill.set("lastredeemdate", null);
        OperateOption option = OperateOption.create();
        option.setVariableValue("pass_isinit_validate", "true");
        OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"cim_redeem", (DynamicObject[])releaseBills, (OperateOption)option);
        for (DynamicObject redeemBill : dbRedeemBills = TmcDataServiceHelper.load((String)"cim_redeem", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)saveResult.getSuccessPkIds())})) {
            redeemBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dbRedeemBills);
    }
}

