/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.init;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeInitSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("org");
        selector.add("redeemamount");
        selector.add("handredeemamt");
        selector.add("redeemway");
        selector.add("amount");
        selector.add("handredeemamt");
        selector.add("surplusamount");
        selector.add("redeemcopies");
        selector.add("handredeemcopies");
        selector.add("buycopies");
        selector.add("handredeemcopies");
        selector.add("surpluscopies");
        selector.add("totalamount");
        selector.add("handrevenueamt");
        selector.add("handlastrevenuedate");
        selector.add("endinstdate");
        selector.add("lastinstdate");
        selector.add("handendpredate");
        selector.add("lastpayinstdate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject initBill : dataEntities) {
            if (EmptyUtil.isEmpty((String)initBill.getString("billno"))) {
                Object orgId = initBill.getDynamicObject("org").getPkValue();
                String billNo = CodeRuleHelper.generateNumber((String)"cim_finsubscribe", (DynamicObject)TmcDataServiceHelper.newDynamicObject((String)"cim_finsubscribe"), (String)orgId.toString(), (String)"");
                initBill.set("billno", (Object)billNo);
            }
            this.setInitBillColumn(initBill);
        }
    }

    private void setInitBillColumn(DynamicObject initBill) {
        initBill.set("redeemamount", (Object)initBill.getBigDecimal("handredeemamt"));
        String redeemWay = initBill.getString("redeemway");
        if (RedeemWayEnum.isAmountRedeem((String)redeemWay)) {
            BigDecimal redeemAmt;
            BigDecimal finAmt = Optional.ofNullable(initBill.getBigDecimal("amount")).orElse(BigDecimal.ZERO);
            BigDecimal surpAmt = finAmt.subtract(redeemAmt = Optional.ofNullable(initBill.getBigDecimal("handredeemamt")).orElse(BigDecimal.ZERO));
            initBill.set("surplusamount", (Object)(surpAmt.compareTo(BigDecimal.ZERO) > 0 ? surpAmt : BigDecimal.ZERO));
        } else {
            initBill.set("redeemcopies", (Object)initBill.getBigDecimal("handredeemcopies"));
            BigDecimal buyCopy = Optional.ofNullable(initBill.getBigDecimal("buycopies")).orElse(BigDecimal.ZERO);
            BigDecimal redeemCopy = Optional.ofNullable(initBill.getBigDecimal("handredeemcopies")).orElse(BigDecimal.ZERO);
            BigDecimal surpCopy = buyCopy.subtract(redeemCopy);
            initBill.set("surpluscopies", (Object)(surpCopy.compareTo(BigDecimal.ZERO) > 0 ? surpCopy : BigDecimal.ZERO));
        }
        initBill.set("totalamount", (Object)initBill.getBigDecimal("handrevenueamt"));
        Date handLastRevDate = initBill.getDate("handlastrevenuedate");
        initBill.set("endinstdate", (Object)handLastRevDate);
        Date date = Optional.ofNullable(initBill.getDate("endinstdate")).map(r -> DateUtils.getNextDay((Date)r, (int)1)).orElse(null);
        initBill.set("lastinstdate", (Object)date);
        Date handIntPreDate = initBill.getDate("handendpredate");
        if (EmptyUtil.isEmpty((Object)handIntPreDate) && EmptyUtil.isNoEmpty((Object)handLastRevDate)) {
            initBill.set("handendpredate", (Object)handLastRevDate);
            handIntPreDate = handLastRevDate;
        }
        initBill.set("lastpayinstdate", (Object)handIntPreDate);
    }
}

