/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeInitUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("handredeemamt");
        selector.add("handredeemcopies");
        selector.add("handrevenueamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        this.cancelInitRedeemBill(dataEntities);
        this.cancelInitRevenueBill(dataEntities);
        BusinessHelper.deleteAttachment((DynamicObject[])dataEntities, (String)"cim_finsubscribe");
    }

    private void cancelInitRedeemBill(DynamicObject[] dataEntities) {
        List finIdList = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handredeemamt")) || EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handredeemcopies"))).map(r -> r.getPkValue()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(finIdList)) {
            return;
        }
        QFilter qFilter = new QFilter("sourcebillid", "in", finIdList);
        qFilter.and(new QFilter("isinit", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        List redeemIdList = QueryServiceHelper.queryPrimaryKeys((String)"cim_redeem", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)redeemIdList)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("pass_isinit_validate", "true");
        TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"cim_redeem", (Object[])redeemIdList.toArray(), (OperateOption)option);
        TmcOperateServiceHelper.execOperate((String)"delete", (String)"cim_redeem", (Object[])redeemIdList.toArray(), (OperateOption)option);
    }

    private void cancelInitRevenueBill(DynamicObject[] dataEntities) {
        List finIdList = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handrevenueamt"))).map(r -> r.getPkValue()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(finIdList)) {
            return;
        }
        QFilter qFilter = new QFilter("finbillno", "in", finIdList);
        qFilter.and(new QFilter("isinit", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        List revenueIdList = QueryServiceHelper.queryPrimaryKeys((String)"cim_revenue", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)revenueIdList)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("pass_isinit_validate", "true");
        TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"cim_revenue", (Object[])revenueIdList.toArray(), (OperateOption)option);
        TmcOperateServiceHelper.execOperate((String)"delete", (String)"cim_revenue", (Object[])revenueIdList.toArray(), (OperateOption)option);
    }
}

