/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.intbatch;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillBatchAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("bizdate");
        selector.add("preintdate");
        selector.add("finbillid");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("intdays");
        selector.add("interestamt");
        selector.add("intdetailnum");
        selector.add("intbillid");
        selector.add("actualinstamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchIntBill : dataEntities) {
            DynamicObjectCollection batchInEntrys = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject batchIntEntry : batchInEntrys) {
                DynamicObject targetBill = TmcDataServiceHelper.loadSingle((Object)batchIntEntry.getLong("intbillid"), (String)"cim_intbill_revenue");
                this.auditRelateBill(batchIntEntry, targetBill);
            }
        }
    }

    private void auditRelateBill(DynamicObject batchIntEntry, DynamicObject targetBills) {
        if (EmptyUtil.isEmpty((DynamicObject)targetBills)) {
            return;
        }
        String entityName = targetBills.getDataEntityType().getName();
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("intbatch", "true");
        operate.setVariableValue("WF", "TRUE");
        DynamicObject targetBill = TmcDataServiceHelper.loadSingle((Object)batchIntEntry.getLong("intbillid"), (String)entityName);
        targetBill.set("amount", (Object)batchIntEntry.getBigDecimal("actualinstamt"));
        try {
            TmcOperateServiceHelper.execOperate((String)"audit", (String)entityName, (DynamicObject[])new DynamicObject[]{targetBill}, (OperateOption)operate, (boolean)false);
        }
        catch (Exception e) {
            batchIntEntry.set("status", (Object)"fail");
            batchIntEntry.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u9884\u63d0\u5355\u5ba1\u6838\u5931\u8d25\uff1a%s\u3002", (String)"IntBillBatchAuditService_0", (String)"tmc-cim-business", (Object[])new Object[0]), e.getMessage().length() > 50 ? e.getMessage().substring(0, 40) : e.getMessage()));
        }
    }
}

