/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.redeem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RedeemBillAuditService
extends AbstractTmcBizOppService {
    private Map<Object, Boolean> isClearMap = new HashMap<Object, Boolean>(2);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("finbillno");
        sic.add("amount");
        sic.add("copies");
        sic.add("tradechannel");
        sic.add("redeemway");
        sic.add("isrevenue");
        sic.add("realrevenue");
        sic.add("isrenewal");
        sic.add("ispushrev");
        sic.add("redeemdate");
        sic.add("redeemapply");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Object> auditID = new ArrayList<Object>();
        for (DynamicObject dataEntitie : dataEntities) {
            boolean isRenewal;
            DynamicObject redeemApply;
            DynamicObject finBillF7 = dataEntitie.getDynamicObject("finbillno");
            if (EmptyUtil.isNoEmpty((DynamicObject)finBillF7)) {
                TmcBotpHelper.saveRelation((String)CimEntityEnum.cim_finsubscribe.getValue(), (Long)((Long)finBillF7.getPkValue()), (String)CimEntityEnum.cim_redeem.getValue(), (Long)((Long)dataEntitie.getPkValue()));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(redeemApply = dataEntitie.getDynamicObject("redeemapply")))) {
                TmcBotpHelper.saveRelation((String)"cim_finapply", (Long)((Long)redeemApply.getPkValue()), (String)CimEntityEnum.cim_redeem.getValue(), (Long)((Long)dataEntitie.getPkValue()));
            }
            DynamicObject finSubscribe = TmcDataServiceHelper.loadSingle((Object)finBillF7.getPkValue(), (String)CimEntityEnum.cim_finsubscribe.getValue());
            String tradeChannel = dataEntitie.getString("tradechannel");
            if (!TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                this.writeBackFinBill(finSubscribe, dataEntitie);
            }
            boolean isRevenue = dataEntitie.getBoolean("isrevenue");
            boolean isPushRev = dataEntitie.getBoolean("ispushrev");
            if (isRevenue && isPushRev && !TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                QFilter qFilter = new QFilter("redeemid", "=", dataEntitie.getPkValue());
                DynamicObject revenueBill = TmcDataServiceHelper.loadSingle((String)CimEntityEnum.cim_revenue.getValue(), (String)"id", (QFilter[])qFilter.toArray());
                auditID.add(revenueBill.getPkValue());
            }
            if (!(isRenewal = dataEntitie.getBoolean("isrenewal"))) continue;
            this.copyFinSubscribe(finSubscribe);
            if (!TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) continue;
            this.writeBackFinBill(finSubscribe, dataEntitie);
        }
        if (auditID.size() > 0) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("redeemAudit", "true");
            TmcOperateServiceHelper.execOperate((String)"audit", (String)CimEntityEnum.cim_revenue.getValue(), (Object[])auditID.toArray(), (OperateOption)operateOption);
        }
    }

    private void writeBackFinBill(DynamicObject finSubscribe, DynamicObject dataEntitie) {
        String redeemWay = dataEntitie.getString("redeemway");
        finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_part.getValue());
        if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            boolean isRevenue;
            BigDecimal redeemAmount = finSubscribe.getBigDecimal("redeemamount").add(dataEntitie.getBigDecimal("amount"));
            finSubscribe.set("redeemamount", (Object)redeemAmount);
            BigDecimal finAmount = finSubscribe.getBigDecimal("amount");
            BigDecimal surplusAmount = finAmount.subtract(redeemAmount);
            finSubscribe.set("surplusamount", (Object)surplusAmount);
            if (BigDecimal.ZERO.compareTo(surplusAmount) == 0) {
                finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_end.getValue());
                finSubscribe.set("cleardate", (Object)dataEntitie.getDate("redeemdate"));
                RevenuePlanCalHelper.setPlanRevenueNull((DynamicObject)finSubscribe);
                this.isClearMap.put(finSubscribe.getPkValue(), Boolean.TRUE);
            }
            if (isRevenue = dataEntitie.getBoolean("isrevenue")) {
                BigDecimal realRevenue = dataEntitie.getBigDecimal("realrevenue");
                finSubscribe.set("totalamount", (Object)finSubscribe.getBigDecimal("totalamount").add(realRevenue));
            }
        }
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal redeemCopies = finSubscribe.getBigDecimal("redeemcopies").add(dataEntitie.getBigDecimal("copies"));
            finSubscribe.set("redeemcopies", (Object)redeemCopies);
            BigDecimal finCopies = finSubscribe.getBigDecimal("buycopies");
            BigDecimal surplusCopies = finCopies.subtract(redeemCopies);
            finSubscribe.set("surpluscopies", (Object)surplusCopies);
            if (EmptyUtil.isEmpty((BigDecimal)surplusCopies)) {
                finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_end.getValue());
                finSubscribe.set("cleardate", (Object)dataEntitie.getDate("redeemdate"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finSubscribe});
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntitie : dataEntities) {
            DynamicObject finBillF7 = dataEntitie.getDynamicObject("finbillno");
            Object finId = finBillF7.getPkValue();
            if (!EmptyUtil.isEmpty((Object)this.isClearMap.get(finId))) continue;
            RevenuePlanCalHelper.calRevenuePlan((Long)((Long)finId), (String)CimEntityEnum.cim_finsubscribe.getValue(), (Map)this.operationVariable);
        }
    }

    private void copyFinSubscribe(DynamicObject finSubscribe) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("from_redeemrenewal", " true");
        TmcOperateServiceHelper.execOperate((String)"redeemrenewal", (String)CimEntityEnum.cim_finsubscribe.getValue(), (DynamicObject[])new DynamicObject[]{finSubscribe}, (OperateOption)option);
    }
}

