/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.redeem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinBizStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RedeemBillDelService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("finbillno");
        sic.add("sourcebilltype");
        sic.add("sourcebillid");
        sic.add("bankcheckflag");
        sic.add("redeemapply");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<Long> applyIdList = Arrays.asList(dataEntities).stream().filter(r -> EmptyUtil.isNoEmpty((DynamicObject)r.getDynamicObject("redeemapply"))).map(r -> r.getLong("redeemapply.id")).collect(Collectors.toList());
        for (DynamicObject dataEntitie : dataEntities) {
            DynamicObject redeemApply;
            DynamicObject sourBill = TmcBotpHelper.getSourceBill((String)CimEntityEnum.cim_redeem.getValue(), (Object)dataEntitie.getPkValue(), (String)CimEntityEnum.cim_finsubscribe.getValue());
            if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
                TmcBotpHelper.deleteRation((String)CimEntityEnum.cim_redeem.getValue(), (Long)sourBill.getLong("id"), (Long)dataEntitie.getLong("id"));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(redeemApply = dataEntitie.getDynamicObject("redeemapply")))) continue;
            TmcBotpHelper.deleteRation((String)"cim_redeem", (Long)redeemApply.getLong("id"), (Long)dataEntitie.getLong("id"));
        }
        this.writeBackFinApply(applyIdList);
        this.writeBackRedeem(dataEntities);
    }

    private void writeBackRedeem(DynamicObject[] dataEntities) {
        Object[] srcRedeemIds = Arrays.stream(dataEntities).map(v -> v.getLong("bankcheckflag")).toArray();
        if (EmptyUtil.isEmpty((Object[])srcRedeemIds)) {
            return;
        }
        DynamicObject[] srcRedeems = TmcDataServiceHelper.load((String)"cim_redeem", (String)"id,sourcebillid,sourcebilltype,billno,isresubmit", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)srcRedeemIds)});
        Map<Long, DynamicObject> srcRedeemMap = Arrays.stream(srcRedeems).collect(Collectors.toMap(v -> v.getLong("id"), o -> o));
        ArrayList<DynamicObject> srcRedeemList = new ArrayList<DynamicObject>(srcRedeems.length);
        for (DynamicObject redeemBill : dataEntities) {
            Long srcRedeemId = redeemBill.getLong("bankcheckflag");
            DynamicObject srcRedeemBill = srcRedeemMap.get(srcRedeemId);
            if (EmptyUtil.isEmpty((DynamicObject)srcRedeemBill)) continue;
            srcRedeemBill.set("isresubmit", (Object)false);
            srcRedeemList.add(srcRedeemBill);
            Long sourcebillid = srcRedeemBill.getLong("sourcebillid");
            if (!EmptyUtil.isNoEmpty((Long)sourcebillid)) continue;
            String sourceBillType = srcRedeemBill.getString("sourcebilltype");
            TmcBotpHelper.deleteRation((String)sourceBillType, (Long)sourcebillid, (Long)srcRedeemBill.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])srcRedeemList.toArray(new DynamicObject[0]));
    }

    private void writeBackFinApply(List<Long> finApplyIdList) {
        DynamicObject[] finApplys;
        if (EmptyUtil.isEmpty(finApplyIdList)) {
            return;
        }
        for (DynamicObject finApply : finApplys = TmcDataServiceHelper.load((String)"cim_finapply", (String)"issubscribe,finservicestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", finApplyIdList)})) {
            finApply.set("issubscribe", (Object)false);
            finApply.set("finservicestatus", (Object)FinBizStatusEnum.UNHANDLE.getValue());
        }
        SaveServiceHelper.update((DynamicObject[])finApplys);
    }
}

