/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.redeem;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RedeemBillUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("isrevenue");
        sic.add("finbillno");
        sic.add("amount");
        sic.add("copies");
        sic.add("redeemway");
        sic.add("tradechannel");
        sic.add("realrevenue");
        sic.add("isrenewal");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntitie : dataEntities) {
            boolean isRenewal;
            DynamicObject finBillF7 = dataEntitie.getDynamicObject("finbillno");
            String tradeChannel = dataEntitie.getString("tradechannel");
            if (!TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                this.writeBackFinBill(finBillF7, dataEntitie);
            }
            boolean isRevenue = dataEntitie.getBoolean("isrevenue");
            Long pkID = dataEntitie.getLong("id");
            if (isRevenue) {
                OperationResult result;
                QFilter qFilter = new QFilter("redeemid", "=", (Object)pkID);
                DynamicObject revenueBill = TmcDataServiceHelper.loadSingle((String)CimEntityEnum.cim_revenue.getValue(), (String)"id", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)revenueBill) && !(result = TmcOperateServiceHelper.execOperate((String)"directdelete", (String)CimEntityEnum.cim_revenue.getValue(), (DynamicObject[])new DynamicObject[]{revenueBill}, (OperateOption)OperateOption.create())).isSuccess()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25. \u5220\u9664\u6536\u76ca\u5355\u5931\u8d25,\u5931\u8d25\u4fe1\u606f:%s\u3002", (String)"RedeemBillUnAuditService_1", (String)"tmc-cim-business", (Object[])new Object[]{result.getMessage()}));
                }
            }
            if (!(isRenewal = dataEntitie.getBoolean("isrenewal"))) continue;
            if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                this.writeBackFinBill(finBillF7, dataEntitie);
            }
            QFilter qFilter = new QFilter("sourbillno", "=", (Object)finBillF7.getString("number"));
            qFilter.and("isrenewal", "=", (Object)"1");
            DynamicObject finBill = TmcDataServiceHelper.loadSingle((String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"id", (QFilter[])qFilter.toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObject)finBill)) continue;
            TmcOperateServiceHelper.execOperate((String)"directdelete", (String)CimEntityEnum.cim_finsubscribe.getValue(), (DynamicObject[])new DynamicObject[]{finBill}, (OperateOption)OperateOption.create());
        }
    }

    private void writeBackFinBill(DynamicObject finBillF7, DynamicObject dataEntitie) {
        DynamicObject finSubscribe = TmcDataServiceHelper.loadSingle((Object)finBillF7.getPkValue(), (String)CimEntityEnum.cim_finsubscribe.getValue());
        String redeemWay = dataEntitie.getString("redeemway");
        finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_part.getValue());
        finSubscribe.set("cleardate", null);
        if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            boolean isRevenue;
            BigDecimal curRedAmount = dataEntitie.getBigDecimal("amount");
            BigDecimal redeemAmount = finSubscribe.getBigDecimal("redeemamount").subtract(curRedAmount);
            finSubscribe.set("redeemamount", (Object)redeemAmount);
            BigDecimal surAmount = finSubscribe.getBigDecimal("surplusamount");
            BigDecimal calSurAmount = surAmount.add(curRedAmount);
            finSubscribe.set("surplusamount", (Object)calSurAmount);
            BigDecimal finAmount = finSubscribe.getBigDecimal("amount");
            if (finAmount.compareTo(calSurAmount) == 0) {
                finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_done.getValue());
            }
            if (isRevenue = dataEntitie.getBoolean("isrevenue")) {
                BigDecimal realRevenue = dataEntitie.getBigDecimal("realrevenue");
                finSubscribe.set("totalamount", (Object)finSubscribe.getBigDecimal("totalamount").subtract(realRevenue));
            }
        }
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal curCopies = dataEntitie.getBigDecimal("copies");
            BigDecimal redeemCopies = finSubscribe.getBigDecimal("redeemcopies").subtract(curCopies);
            finSubscribe.set("redeemcopies", (Object)redeemCopies);
            BigDecimal surCopies = finSubscribe.getBigDecimal("surpluscopies");
            BigDecimal calPlusCopies = surCopies.add(curCopies);
            finSubscribe.set("surpluscopies", (Object)calPlusCopies);
            BigDecimal finCopies = finSubscribe.getBigDecimal("buycopies");
            if (calPlusCopies.compareTo(finCopies) == 0) {
                finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_done.getValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finSubscribe});
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntitie : dataEntities) {
            DynamicObject finBillF7 = dataEntitie.getDynamicObject("finbillno");
            RevenuePlanCalHelper.calRevenuePlan((Long)((Long)finBillF7.getPkValue()), (String)CimEntityEnum.cim_finsubscribe.getValue(), (Map)this.operationVariable);
        }
    }
}

