/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.revenue;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevenueBillSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("finbillno");
        sic.add("revenuesort");
        sic.add("revenuestartdate");
        sic.add("revenueenddate");
        sic.add("expiredate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (this.getOperationVariable().containsKey("redwriteoffop")) {
            return;
        }
        if (this.getOperationVariable().containsKey("op_from_isc")) {
            this.saveFromISC(dataEntities);
            return;
        }
        for (DynamicObject dataEntitie : dataEntities) {
            String revenueSort = dataEntitie.getString("revenuesort");
            if (RevenueSortEnum.revenue.getValue().equals(revenueSort)) {
                this.createByNormalSave(dataEntitie);
                continue;
            }
            this.createByBotpSave(dataEntitie);
        }
    }

    private void createByNormalSave(DynamicObject dataEntitie) {
        DynamicObject finBillNoF7 = dataEntitie.getDynamicObject("finbillno");
        if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) {
            TmcBotpHelper.saveRelation((String)CimEntityEnum.cim_finsubscribe.getValue(), (Long)((Long)finBillNoF7.getPkValue()), (String)CimEntityEnum.cim_revenue.getValue(), (Long)((Long)dataEntitie.getPkValue()));
            Date beginDate = dataEntitie.getDate("revenuestartdate");
            Date endDate = dataEntitie.getDate("expiredate");
            IntBillInfo intBill = RevenueCalcHelper.callInt((Long)((Long)finBillNoF7.getPkValue()), (Date)beginDate, (Date)endDate);
            if (intBill != null) {
                dataEntitie.set("revenueamount", (Object)intBill.getAmount());
                DynamicObjectCollection entrys = dataEntitie.getDynamicObjectCollection("entrys");
                if (EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
                    RevenueCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getDetails());
                }
            }
        }
    }

    private void createByBotpSave(DynamicObject revenueBill) {
        IntBillInfo intBill;
        Date redeemDate = DateUtils.stringToDate((String)((String)this.operationVariable.get("redeemDate")), (String)"yyyy-MM-dd");
        revenueBill.set("expiredate", (Object)redeemDate);
        revenueBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        Date endinstdate = DateUtils.getLastDay((Date)redeemDate, (int)1);
        revenueBill.set("revenueenddate", (Object)endinstdate);
        revenueBill.set("amount", (Object)new BigDecimal((String)this.operationVariable.get("realRevenue")));
        revenueBill.set("combineinst", (Object)Boolean.parseBoolean((String)this.operationVariable.get("combineinst")));
        DynamicObject finBillF7 = revenueBill.getDynamicObject("finbillno");
        Long finBillId = (Long)finBillF7.getPkValue();
        DynamicObject finSubscribe = TmcDataServiceHelper.loadSingle((Object)finBillId, (String)CimEntityEnum.cim_finsubscribe.getValue());
        Date newEndInstDate = finSubscribe.getDate("endinstdate");
        if (EmptyUtil.isNoEmpty((Object)newEndInstDate)) {
            revenueBill.set("revenuestartdate", (Object)DateUtils.getNextDay((Date)newEndInstDate, (int)1));
        } else {
            Date actStartIntDate = RevenueCalcHelper.getStartIntDate((DynamicObject)finSubscribe);
            revenueBill.set("revenuestartdate", (Object)actStartIntDate);
        }
        BigDecimal surplusAmount = new BigDecimal((String)this.operationVariable.get("surplusAmount"));
        if (BigDecimal.ZERO.compareTo(surplusAmount) != 0) {
            intBill = RevenueCalcHelper.callInt((Long)finBillId, (Date)redeemDate, (BigDecimal)new BigDecimal((String)this.operationVariable.get("amount")));
        } else {
            Date beginDate = revenueBill.getDate("revenuestartdate");
            intBill = RevenueCalcHelper.callInt((Long)finBillId, (Date)beginDate, (Date)redeemDate);
        }
        Date revenueStartDate = revenueBill.getDate("revenuestartdate");
        Date revenueEndDate = revenueBill.getDate("revenueenddate");
        if (EmptyUtil.isNoEmpty((Object)revenueStartDate) && EmptyUtil.isNoEmpty((Object)revenueEndDate)) {
            revenueBill.set("revenuedays", (Object)DateUtils.getDiffDays((Date)revenueStartDate, (Date)revenueEndDate));
        }
        if (intBill != null) {
            revenueBill.set("revenueamount", (Object)intBill.getAmount());
            DynamicObjectCollection entrys = revenueBill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
                RevenueCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getDetails());
            }
        }
        revenueBill.set("realrate", (Object)RevenueCalcHelper.calcRealRate((DynamicObjectCollection)revenueBill.getDynamicObjectCollection("entrys"), (BigDecimal)revenueBill.getBigDecimal("amount")));
    }

    private void saveFromISC(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntitie : dataEntities) {
            DynamicObject finBillNoF7 = dataEntitie.getDynamicObject("finbillno");
            if (!EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) continue;
            TmcBotpHelper.saveRelation((String)CimEntityEnum.cim_finsubscribe.getValue(), (Long)((Long)finBillNoF7.getPkValue()), (String)CimEntityEnum.cim_revenue.getValue(), (Long)((Long)dataEntitie.getPkValue()));
        }
    }
}

