/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.scheme;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSchemeSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        String saveParam = this.getOperationVariable().getOrDefault("fromfinapply", null);
        if (EmptyUtil.isNoEmpty((String)saveParam)) {
            return;
        }
        for (DynamicObject finScheme : dataEntities) {
            this.setLinkInfo(finScheme);
            BigDecimal planRevenue = finScheme.getBigDecimal("planrevenue");
            if (EmptyUtil.isEmpty((BigDecimal)planRevenue)) {
                finScheme.set("planrevenue", (Object)0);
            }
            this.syncSchemeInfo(finScheme);
            finScheme.set("status", (Object)finScheme.getDynamicObject("finapply").getString("billstatus"));
        }
    }

    private void syncSchemeInfo(DynamicObject finScheme) {
        DynamicObject finApply = finScheme.getDynamicObject("finapply");
        DynamicObject finSchemeFromDB = TmcDataServiceHelper.loadSingle((String)"cim_finscheme", (String)"finapply", (QFilter[])new QFilter[]{new QFilter("id", "=", finScheme.getPkValue())});
        ArrayList<DynamicObject> modifyFinApplys = new ArrayList<DynamicObject>(16);
        DynamicObject finApplyFromDB = TmcDataServiceHelper.loadSingle((Object)finApply.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_finapply"));
        DynamicObjectCollection schemeEntrys = finApplyFromDB.getDynamicObjectCollection("entry");
        Map map = schemeEntrys.stream().filter(v -> EmptyUtil.isNoEmpty((Long)v.getLong("e_schemeid"))).collect(Collectors.toMap(v -> v.getLong("e_schemeid"), o -> o, (o1, o2) -> o1, HashMap::new));
        DynamicObject scheme = null;
        if (EmptyUtil.isEmpty((DynamicObject)finSchemeFromDB)) {
            scheme = schemeEntrys.addNew();
        } else if (finApply.getString("number").equals(finSchemeFromDB.getDynamicObject("finapply").getString("number"))) {
            scheme = (DynamicObject)map.get(finScheme.getLong("id"));
        } else {
            scheme = schemeEntrys.addNew();
            DynamicObject oldFinApply = TmcDataServiceHelper.loadSingle((Object)finSchemeFromDB.getDynamicObject("finapply").getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_finapply"));
            oldFinApply.getDynamicObjectCollection("entry").removeIf(row -> row.getLong("e_schemeid") == finScheme.getLong("id"));
            modifyFinApplys.add(oldFinApply);
        }
        modifyFinApplys.add(finApplyFromDB);
        this.copyProperties(finScheme, scheme);
        SaveServiceHelper.save((DynamicObject[])modifyFinApplys.toArray(new DynamicObject[0]));
    }

    private void setLinkInfo(DynamicObject finScheme) {
        String redeemWay = finScheme.getString("redeemway");
        if (StringUtils.equals((CharSequence)redeemWay, (CharSequence)RedeemWayEnum.amount_redeem.getValue())) {
            finScheme.set("buycopies", null);
        } else {
            finScheme.set("intdate", null);
            finScheme.set("revenueproject", null);
        }
    }

    private void copyProperties(DynamicObject srcObj, DynamicObject targetObj) {
        DataEntityPropertyCollection properties = targetObj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (propName.equals("e_isselect")) continue;
            if (propName.equals("e_schemeid")) {
                targetObj.set(propName, (Object)srcObj.getLong("id"));
                continue;
            }
            if (propName.equals("e_explain")) {
                targetObj.set(propName, srcObj.get("comment"));
                continue;
            }
            if (!propName.startsWith("e_")) continue;
            targetObj.set(propName, srcObj.get(propName.replace("e_", "")));
        }
    }
}

