/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.supermarket;

import java.sql.ResultSet;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class InterfaceSetSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject interBill = dataEntities[0];
        DynamicObject bankCate = interBill.getDynamicObject("bankcate");
        String faceNumber = interBill.getString("interface");
        long currUserId = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        try (TXHandle tx = TX.requiresNew();){
            long bankCateId = bankCate.getLong("id");
            Long pkId = this.getPkIdFromDB(bankCateId);
            if (pkId > 0L) {
                String updateStr = "UPDATE T_CIM_INTERFACESET SET FINTERFACE=?,FMODIFIERID=?,FMODIFYTIME=? WHERE FID=?";
                TmcDataServiceHelper.execute((DBRoute)DBRouteConst.TMC, (String)updateStr, (Object[])new Object[]{faceNumber, currUserId, currDate, pkId});
            } else {
                String insertStr = "INSERT INTO T_CIM_INTERFACESET (FID,FBANKCATE,FINTERFACE,FMODIFIERID,FMODIFYTIME) VALUES (?,?,?,?,?)";
                pkId = DB.genLongId((String)"cim_interfaceset");
                TmcDataServiceHelper.execute((DBRoute)DBRouteConst.TMC, (String)insertStr, (Object[])new Object[]{pkId, bankCateId, faceNumber, currUserId, currDate});
            }
        }
    }

    private Long getPkIdFromDB(long bankcate) {
        String queryStr = "SELECT FID FROM T_CIM_INTERFACESET WHERE FBANKCATE=?";
        Long pkId = (Long)DB.query((DBRoute)DBRouteConst.TMC, (String)queryStr, (Object[])new Object[]{bankcate}, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet resultSet) throws Exception {
                Long fid = 0L;
                while (resultSet.next()) {
                    fid = resultSet.getLong(1);
                }
                return fid;
            }
        });
        return pkId;
    }
}

