/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.supermarket;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.cim.common.enums.SupermarketCardEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuperMarketDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bankcate");
        selector.add("prdcardid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, List> cardMap = new HashMap<Long, List>(dataEntities.length);
        for (DynamicObject marketBill : dataEntities) {
            DynamicObject bankCateBill = marketBill.getDynamicObject("bankcate");
            if (EmptyUtil.isEmpty((DynamicObject)bankCateBill)) continue;
            List cardIds = cardMap.computeIfAbsent(bankCateBill.getLong("id"), k -> new ArrayList());
            cardIds.add(marketBill.getLong("prdcardid"));
        }
        for (Map.Entry entry : cardMap.entrySet()) {
            SupermarketCardEnum cardEnum = SupermarketCardEnum.getEnumByBankCateId((Long)((Long)entry.getKey()));
            if (!EmptyUtil.isNoEmpty((Object)cardEnum)) continue;
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)cardEnum.getCardEntity()), (Object[])((List)entry.getValue()).toArray());
        }
    }
}

