/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeAutoRedeemService
extends AbstractTmcBizOppService {
    private static final Log LOG = LogFactory.getLog(FinSubscribeAutoRedeemService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map opMap = this.getOperationVariable();
        String revenueBillStatus = BillStatusEnum.SAVE.getValue();
        String billstatusParam = (String)opMap.get("billstatus_param");
        if (EmptyUtil.isNoEmpty((String)billstatusParam)) {
            revenueBillStatus = billstatusParam;
        }
        Object[] finsubIds = Arrays.stream(dataEntities).map(r -> r.getLong("id")).toArray();
        DynamicObject[] finsubBills = TmcDataServiceHelper.load((Object[])finsubIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_finsubscribe"));
        ArrayList<DynamicObject> redeemList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject finsub : finsubBills) {
            try {
                DynamicObject[] redeemBills = TmcBotpHelper.push((DynamicObject)finsub, (String)"cim_redeem");
                DynamicObject redeemBill = redeemBills[0];
                String redeemRule = Optional.ofNullable(finsub.getDynamicObject("productfactory")).map(r -> r.getString("graceadjustrule")).orElse("");
                DynamicObjectCollection workCalendars = finsub.getDynamicObjectCollection("workcalendar");
                if (EmptyUtil.isNoEmpty((String)redeemRule) && EmptyUtil.isNoEmpty((DynamicObjectCollection)workCalendars)) {
                    AdjustMethodEnum adjustMethod = AdjustMethodEnum.valueOf((String)redeemRule);
                    Date expireDate = finsub.getDate("expiredate");
                    Date adjustExpireDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)expireDate, (AdjustMethodEnum)adjustMethod);
                    redeemBill.set("redeemdate", (Object)adjustExpireDate);
                    int redeemPattern = redeemBill.getInt("redeempattern");
                    redeemBill.set("expiredate", (Object)DateUtils.getNextDay((Date)adjustExpireDate, (int)redeemPattern));
                }
                redeemList.add(redeemBill);
            }
            catch (Exception e) {
                LOG.error("AutoRedeem Schedule occured an exception: finsubNo={},exception={},e={}", new Object[]{finsub.getString("billno"), e.getMessage(), e});
            }
        }
        OperateOption option = OperateOption.create();
        OperationResult saveResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"save", (String)"cim_redeem", (DynamicObject[])redeemList.toArray(new DynamicObject[0]), (OperateOption)option);
        if (BillStatusEnum.SAVE.getValue().equals(revenueBillStatus) || EmptyUtil.isEmpty((Object)saveResult) || !saveResult.isSuccess()) {
            return;
        }
        option.setVariableValue("WF", "TRUE");
        List releaseIds = saveResult.getSuccessPkIds();
        OperationResult submitResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"submit", (String)"cim_redeem", (Object[])releaseIds.toArray(), (OperateOption)option);
        if (BillStatusEnum.isAudit((String)revenueBillStatus) && EmptyUtil.isNoEmpty((Object)submitResult) && submitResult.isSuccess()) {
            releaseIds = submitResult.getSuccessPkIds();
            TmcOperateServiceHelper.execOperateWithoutThrow((String)"audit", (String)"cim_redeem", (Object[])releaseIds.toArray(), (OperateOption)option);
        }
    }
}

