/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeAutoRevenueService
extends AbstractTmcBizOppService {
    private static final Log LOG = LogFactory.getLog(FinSubscribeAutoRevenueService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map operationVariable = this.getOperationVariable();
        String revenueBillStatus = BillStatusEnum.SAVE.getValue();
        String status = (String)operationVariable.get("billstatus");
        if (EmptyUtil.isNoEmpty((String)status)) {
            revenueBillStatus = status;
        }
        Object[] finsubIds = Arrays.stream(dataEntities).map(r -> r.getLong("id")).toArray();
        DynamicObject[] finsubBills = TmcDataServiceHelper.load((Object[])finsubIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_finsubscribe"));
        ArrayList<DynamicObject> revenueList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject finsub : finsubBills) {
            try {
                DynamicObject[] revenueBills = TmcBotpHelper.push((DynamicObject)finsub, (String)"cim_revenue");
                DynamicObject revenueBill = revenueBills[0];
                revenueList.add(revenueBill);
            }
            catch (Exception e) {
                LOG.error("AutoRevenue Schedule occured an exception: finsubNo={},exception={},e={}", new Object[]{finsub.getString("billno"), e.getMessage(), e});
            }
        }
        OperateOption option = OperateOption.create();
        OperationResult saveResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"save", (String)"cim_revenue", (DynamicObject[])revenueList.toArray(new DynamicObject[0]), (OperateOption)option);
        if ("save".equals(revenueBillStatus) || EmptyUtil.isEmpty((Object)saveResult) || !saveResult.isSuccess()) {
            return;
        }
        option.setVariableValue("WF", "TRUE");
        List revenueIds = saveResult.getSuccessPkIds();
        OperationResult submitResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"submit", (String)"cim_revenue", (Object[])revenueIds.toArray(), (OperateOption)option);
        if ("audit".equals(revenueBillStatus) && EmptyUtil.isNoEmpty((Object)submitResult) && submitResult.isSuccess()) {
            revenueIds = submitResult.getSuccessPkIds();
            TmcOperateServiceHelper.execOperateWithoutThrow((String)"audit", (String)"cim_revenue", (Object[])revenueIds.toArray(), (OperateOption)option);
        }
    }
}

