/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.apply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.cim.common.enums.InterestTypeEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DepositApplySchemeSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Map<String, String> depositApplyErrorMap;
            DynamicObjectCollection cardEntryList;
            DynamicObject depositApply = extendedDataEntity.getDataEntity();
            if (!depositApply.getBoolean("inquiry") || EmptyUtil.isEmpty((DynamicObjectCollection)(cardEntryList = depositApply.getDynamicObjectCollection("s_entry")))) continue;
            ArrayList<String> schemeIds = new ArrayList<String>();
            StringJoiner errorInfoList = new StringJoiner("\n");
            for (DynamicObject cardEntry : cardEntryList) {
                DynamicObject scheme = (DynamicObject)cardEntry.getDynamicObjectCollection("c_entry").get(0);
                Pair<Boolean, String> validateResult = this.validateMustInput(scheme);
                if (!((Boolean)validateResult.getKey()).booleanValue()) {
                    errorInfoList.add(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%1$s\u3002", (String)"DepositApplySchemeSaveValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]), validateResult.getRight()));
                    continue;
                }
                DynamicObject depositScheme = scheme.getDynamicObject("c_depositscheme");
                if (EmptyUtil.isNoEmpty((DynamicObject)depositScheme)) {
                    schemeIds.add(depositScheme.getString("number"));
                }
                this.validateRangeRate(extendedDataEntity, scheme);
            }
            if (errorInfoList.length() > 0) {
                this.addMessage(extendedDataEntity, errorInfoList.toString());
            }
            if ((depositApplyErrorMap = this.validateDepositApply(schemeIds, depositApply.getString("billno"))).size() <= 0) continue;
            for (Map.Entry<String, String> entry : depositApplyErrorMap.entrySet()) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u6b3e\u65b9\u6848%1$s\u5df2\u88ab\u5176\u4ed6\u5b58\u6b3e\u7533\u8bf7\u5355%2$s\u9009\u62e9\u3002", (String)"DepositApplySchemeSaveValidator_13", (String)"tmc-cim-business", (Object[])new Object[0]), entry.getKey(), entry.getValue()));
            }
        }
    }

    private Map<String, String> validateDepositApply(List<String> schemeIds, String selfDepositApplyNo) {
        HashMap<String, String> depositApplyErrorMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(schemeIds)) {
            return depositApplyErrorMap;
        }
        QFilter qFilter = new QFilter("number", "in", schemeIds);
        DynamicObjectCollection depositSchemeFromDBList = QueryServiceHelper.query((String)"cim_depositscheme", (String)"number,depositapply.number", (QFilter[])qFilter.toArray());
        for (DynamicObject depositSchemeFromDB : depositSchemeFromDBList) {
            Object depositApplyNo = depositSchemeFromDB.get("depositapply.number");
            if (EmptyUtil.isEmpty((Object)depositApplyNo) || depositApplyNo.toString().equals(selfDepositApplyNo)) continue;
            depositApplyErrorMap.put(depositSchemeFromDB.getString("number"), depositApplyNo.toString());
        }
        return depositApplyErrorMap;
    }

    private Pair<Boolean, String> validateMustInput(DynamicObject scheme) {
        Map<String, String> mustInputProps = this.getMustInputProps();
        String tradeChannel = scheme.getString("c_tradechannel");
        DynamicObject investVarieties = scheme.getDynamicObject("c_investvarieties");
        String investType = investVarieties == null ? InvestTypeEnum.fixed.getValue() : investVarieties.getString("investtype");
        String interestType = scheme.getString("c_interesttype");
        boolean isSuccess = true;
        StringJoiner nullFields = new StringJoiner("\u3001");
        for (Map.Entry<String, String> propEntry : mustInputProps.entrySet()) {
            String propName = propEntry.getKey();
            Object propValue = scheme.get(propName);
            if (EmptyUtil.isNoEmpty((Object)propValue)) continue;
            if ("c_deadline".equals(propName)) {
                if (!StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)tradeChannel)) continue;
                nullFields.add(propEntry.getValue());
                isSuccess = false;
                continue;
            }
            if ("c_prenoticeday".equals(propName)) {
                if (!InvestTypeEnum.isNotice((String)investType)) continue;
                nullFields.add(propEntry.getValue());
                isSuccess = false;
                continue;
            }
            if (Arrays.asList("c_expiredate", "c_expireredeposit").contains(propName)) {
                if (!InvestTypeEnum.isFixed((String)investType)) continue;
                nullFields.add(propEntry.getValue());
                isSuccess = false;
                continue;
            }
            if ("c_referencerate".equals(propName)) {
                if (!StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)interestType)) continue;
                nullFields.add(propEntry.getValue());
                isSuccess = false;
                continue;
            }
            nullFields.add(propEntry.getValue());
            isSuccess = false;
        }
        return Pair.of((Object)isSuccess, (Object)nullFields.toString());
    }

    private Map<String, String> getMustInputProps() {
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>(32);
        propMap.put("c_tradechannel", ResManager.loadKDString((String)"\u201c\u4ea4\u6613\u6e20\u9053\u201d", (String)"DepositApplySchemeSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_org", ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u7ec4\u7ec7\u201d", (String)"DepositApplySchemeSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_finorginfo", ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u673a\u6784\u201d", (String)"DepositApplySchemeSaveValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_investvarieties", ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u54c1\u79cd\u201d", (String)"DepositApplySchemeSaveValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_prenoticeday", ResManager.loadKDString((String)"\u201c\u63d0\u524d\u901a\u77e5\u5929\u6570\u201d", (String)"DepositApplySchemeSaveValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_currency", ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u5e01\u79cd\u201d", (String)"DepositApplySchemeSaveValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_amount", ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u91d1\u989d\u201d", (String)"DepositApplySchemeSaveValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_intdate", ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u8d77\u606f\u65e5\u201d", (String)"DepositApplySchemeSaveValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_deadline", ResManager.loadKDString((String)"\u201c\u671f\u9650\u201d", (String)"DepositApplySchemeSaveValidator_9", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_expiredate", ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u5230\u671f\u65e5\u201d", (String)"DepositApplySchemeSaveValidator_10", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_interesttype", ResManager.loadKDString((String)"\u201c\u5229\u7387\u7c7b\u578b\u201d", (String)"DepositApplySchemeSaveValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_referencerate", ResManager.loadKDString((String)"\u201c\u53c2\u8003\u5229\u7387\u201d", (String)"DepositApplySchemeSaveValidator_12", (String)"tmc-cim-business", (Object[])new Object[0]));
        return propMap;
    }

    private void validateRangeRate(ExtendedDataEntity extendData, DynamicObject depositApply) {
        List msgList = DepositHelper.validateRangeRate((DynamicObject)depositApply, (boolean)true);
        if (EmptyUtil.isNoEmpty((Object)msgList)) {
            for (String msg : msgList) {
                this.addErrorMessage(extendData, msg);
            }
        }
    }
}

