/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.apply;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositApplySubmitForAgreeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("bankacct");
        selector.add("finorginfo");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject finOrg;
            DynamicObject apply = extData.getDataEntity();
            if (!DepositApplyTypeEnum.isAgree((String)apply.getString("applytype"))) continue;
            if (EmptyUtil.isEmpty((DynamicObject)apply.getDynamicObject("bankacct"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u534f\u5b9a\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositApplySubmitForAgreeValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(finOrg = apply.getDynamicObject("finorginfo")))) continue;
            finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)finOrg.getPkValue(), (String)"bd_finorginfo");
            String finType = Optional.ofNullable(finOrg).map(r -> r.getString("finorgtype.type")).orElse("");
            if (!FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(finType)) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u7ed3\u7b97\u4e2d\u5fc3\u7c7b\u578b\u7684\u5b58\u6b3e\u673a\u6784\u3002", (String)"DepositApplySubmitForAgreeValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

