/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.apply;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.FinApplyTypeEnum;
import kd.tmc.cim.common.enums.FinBizStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinApplyPush2RedeemValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("applytype");
        selector.add("finservicestatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject finApp = extData.getDataEntity();
            if (!BillStatusEnum.isAudit((String)finApp.getString("billstatus")) || !FinBizStatusEnum.UNHANDLE.getValue().equals(finApp.getString("finservicestatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8d4e\u56de\u7533\u8bf7\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u201c\u672a\u529e\u7406\u201d\u7684\u60c5\u51b5\u4e0b\u624d\u80fd\u767b\u8bb0\u8d4e\u56de\u5355\u3002", (String)"FinApplyPush2RedeemValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!FinApplyTypeEnum.REDEEM.getValue().equals(finApp.getString("applytype"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u7533\u8bf7\u7c7b\u578b\u4e3a\u8d4e\u56de\u7533\u8bf7\u7684\u5355\u636e\u5141\u8bb8\u4e0b\u63a8\u8d4e\u56de\u5355\u3002", (String)"FinApplyPush2RedeemValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("sourcebillid", "=", finApp.getPkValue());
            qFilter.or(new QFilter("redeemapply", "=", finApp.getPkValue()));
            DynamicObjectCollection redeemCols = QueryServiceHelper.query((String)"cim_redeem", (String)"billno", (QFilter[])new QFilter[]{qFilter}, (String)"");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)redeemCols)) continue;
            List redeemBills = redeemCols.stream().map(r -> r.getString("billno")).collect(Collectors.toList());
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u6709\u4e0b\u6e38\u8d4e\u56de\u5355\u3010%s\u3011\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u63a8\u3002", (String)"FinApplyPush2RedeemValidator_3", (String)"tmc-cim-business", (Object[])new Object[]{String.join((CharSequence)",", redeemBills)}));
        }
    }
}

