/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.apply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinApplyTypeEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class FinApplySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("applytype");
        sid.add("inquiry");
        sid.add("finsubscribe");
        sid.add("redemptiondate");
        sid.add("redemptionamount");
        sid.add("redeemway");
        sid.add("redemptioncopies");
        sid.add("redemptiondate");
        sid.add("s_entry");
        sid.add("entry");
        sid.add("product");
        sid.add("finorginfo");
        sid.add("amount");
        sid.add("c_product");
        sid.add("c_finorginfo");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Pair<Boolean, String> validateResult;
            DynamicObject finApply = extendedDataEntity.getDataEntity();
            String applyType = finApply.getString("applytype");
            BigDecimal planAmount = finApply.getBigDecimal("planamount");
            BigDecimal planRevenue = finApply.getBigDecimal("planrevenue");
            if (FinApplyTypeEnum.REDEEM.getValue().equals(applyType) && (planRevenue.compareTo(new BigDecimal("100")) > 0 || planRevenue.compareTo(new BigDecimal("-100")) < 0)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u7387\uff08%\uff09\u5fc5\u987b\u5728[-100,100]\u4e4b\u95f4\u3002", (String)"FinApplySubmitValidator_16", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (FinApplyTypeEnum.PURCHASE.getValue().equals(finApply.getString("applytype"))) {
                if (planRevenue.compareTo(new BigDecimal("100")) > 0 || planRevenue.compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u7387\uff08%\uff09\u5fc5\u987b\u5728[0,100]\u4e4b\u95f4\u3002", (String)"FinApplySubmitValidator_17", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (planAmount.compareTo(DepositHelper.RATE_MAX) > 0 || planAmount.compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"FinApplySubmitValidator_18", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            }
            if (FinApplyTypeEnum.PURCHASE.getValue().equals(applyType)) {
                this.validateAmountAndProduct(finApply, extendedDataEntity);
                if (finApply.getBoolean("inquiry")) {
                    DynamicObjectCollection schemeCards = finApply.getDynamicObjectCollection("s_entry");
                    DynamicObjectCollection entrys = finApply.getDynamicObjectCollection("entry");
                    if (!CollectionUtils.isEmpty((Collection)schemeCards) || !CollectionUtils.isEmpty((Collection)entrys)) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7406\u8d22\u65b9\u6848\u4fe1\u606f\u3002", (String)"FinApplySubmitValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                    continue;
                }
            } else {
                this.checkRedeemTypeParam(extendedDataEntity, finApply);
            }
            if (((Boolean)(validateResult = this.validateMustInput(finApply)).getLeft()).booleanValue()) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"FinApplySubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]), validateResult.getRight()));
        }
    }

    private void checkRedeemTypeParam(ExtendedDataEntity extendedDataEntity, DynamicObject finApply) {
        Map checkEndDate;
        Date redeemDate;
        DynamicObject finSubscribe = finApply.getDynamicObject("finsubscribe");
        if (EmptyUtil.isEmpty((DynamicObject)finSubscribe)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7406\u8d22\u7533\u8d2d\u5355\u3002", (String)"FinApplySubmitValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
            return;
        }
        BigDecimal redemptionAmount = finApply.getBigDecimal("redemptionamount");
        if (EmptyUtil.isEmpty((BigDecimal)redemptionAmount)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d4e\u56de\u91d1\u989d\u3002", (String)"FinApplySubmitValidator_12", (String)"tmc-cim-business", (Object[])new Object[0]));
            return;
        }
        String redeemWay = finApply.getString("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal surplusCopies = finSubscribe.getBigDecimal("surpluscopies");
            BigDecimal copies = finApply.getBigDecimal("redemptioncopies");
            if (EmptyUtil.isEmpty((BigDecimal)copies)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d4e\u56de\u4efd\u6570\u3002", (String)"FinApplySubmitValidator_15", (String)"tmc-cim-business", (Object[])new Object[0]));
                return;
            }
            if (copies.compareTo(surplusCopies) > 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d4e\u56de\u4efd\u6570\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7533\u8d2d\u5355\u7684\u5269\u4f59\u4efd\u6570\u3002", (String)"FinApplySubmitValidator_14", (String)"tmc-cim-business", (Object[])new Object[0]));
                return;
            }
        } else {
            BigDecimal amount = finSubscribe.getBigDecimal("surplusamount");
            if (redemptionAmount.compareTo(amount) > 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d4e\u56de\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7533\u8d2d\u5355\u7684\u5269\u4f59\u91d1\u989d\u3002", (String)"FinApplySubmitValidator_13", (String)"tmc-cim-business", (Object[])new Object[0]));
                return;
            }
        }
        if (EmptyUtil.isEmpty((Object)(redeemDate = finApply.getDate("redemptiondate")))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d4e\u56de\u65e5\u671f\u3002", (String)"FinApplySubmitValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
            return;
        }
        String checkRedDate = RedeemBillHelper.checkLastRedeemDate((Object)finSubscribe.getPkValue(), (Date)redeemDate);
        if (EmptyUtil.isNoEmpty((String)checkRedDate)) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4e0a\u4e00\u6b21\u7684\u8d4e\u56de\u65e5\u671f[%s]\u3002", (String)"FinApplySubmitValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]), checkRedDate));
        }
        if ((checkEndDate = RedeemBillHelper.checkLastEndIntDate((Object)finSubscribe.getPkValue(), (Date)redeemDate)).containsKey("lastEndIntDate")) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u7533\u8d2d\u5355\u7684\u4e0a\u6b21\u6536\u76ca\u65e5%s\u3002", (String)"FinApplySubmitValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]), checkEndDate.get("lastEndIntDate")));
        }
        if (checkEndDate.containsKey("purchaseDate")) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u7533\u8d2d\u5355\u7684\u7533\u8d2d\u65e5\u671f%s\u3002", (String)"FinApplySubmitValidator_9", (String)"tmc-cim-business", (Object[])new Object[0]), checkEndDate.get("purchaseDate")));
        }
        QFilter qFilter = new QFilter("finbillno", "=", finSubscribe.getPkValue());
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        boolean exists = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_redeem.getValue(), (QFilter[])qFilter.toArray());
        if (exists) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u8d4e\u56de\u5355\u8bb0\u5f55\u672a\u5904\u7406\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"FinApplySubmitValidator_10", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private Pair<Boolean, String> validateMustInput(DynamicObject finApply) {
        StringJoiner nullFeilds = new StringJoiner("\u3001");
        Map<String, String> mustInputProps = this.getMustInputProps();
        String redeemway = finApply.getString("redeemway");
        DynamicObject finOrgInfo = finApply.getDynamicObject("finorginfo");
        Boolean isSuccess = true;
        for (Map.Entry<String, String> propEntry : mustInputProps.entrySet()) {
            String finOrgType;
            String propName = propEntry.getKey();
            Object propValue = finApply.get(propName);
            if (StringUtils.equals((CharSequence)"productname", (CharSequence)propName)) {
                propValue = finApply.getString(propName);
            }
            if (EmptyUtil.isNoEmpty((Object)propValue)) continue;
            if (Arrays.asList("planrevenue", "intdate", "revenueproject", "revenuetype").contains(propName)) {
                if (!StringUtils.equals((CharSequence)RedeemWayEnum.amount_redeem.getValue(), (CharSequence)redeemway) || "planrevenue".equals(propEntry.getKey()) && finApply.getBigDecimal("planrevenue").compareTo(new BigDecimal(0)) == 0) continue;
                nullFeilds.add(propEntry.getValue());
                isSuccess = false;
                continue;
            }
            if (StringUtils.equals((CharSequence)"finaccountf7", (CharSequence)propName)) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)finOrgInfo) || !(finOrgType = finOrgInfo.getDynamicObject("finorgtype").getString("number")).equals("FI-014") || !EmptyUtil.isEmpty((String)finApply.getString("finaccountf7"))) continue;
                nullFeilds.add(propEntry.getValue());
                isSuccess = false;
                continue;
            }
            if (StringUtils.equals((CharSequence)"finaccount", (CharSequence)propName)) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)finOrgInfo) || (finOrgType = finOrgInfo.getDynamicObject("finorgtype").getString("number")).equals("FI-014") || !EmptyUtil.isEmpty((String)finApply.getString("finaccount"))) continue;
                nullFeilds.add(propEntry.getValue());
                isSuccess = false;
                continue;
            }
            nullFeilds.add(propEntry.getValue());
            isSuccess = false;
        }
        return Pair.of((Object)isSuccess, (Object)nullFeilds.toString());
    }

    private Map<String, String> getMustInputProps() {
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>(32);
        propMap.put("productno", ResManager.loadKDString((String)"\u201c\u7406\u8d22\u4ea7\u54c1\u4ee3\u7801\u201d", (String)"FinApplySchemeSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("productname", ResManager.loadKDString((String)"\u201c\u7406\u8d22\u4ea7\u54c1\u540d\u79f0\u201d", (String)"FinApplySchemeSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("investvarieties", ResManager.loadKDString((String)"\u201c\u6295\u8d44\u54c1\u79cd\u201d", (String)"FinApplySchemeSaveValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("finorginfo", ResManager.loadKDString((String)"\u201c\u53d1\u884c\u673a\u6784\u201d", (String)"FinApplySchemeSaveValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("valuedate", ResManager.loadKDString((String)"\u201c\u7406\u8d22\u5f00\u59cb\u65e5\u201d", (String)"FinApplySchemeSaveValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("redeemway", ResManager.loadKDString((String)"\u201c\u8d4e\u56de\u65b9\u5f0f\u201d", (String)"FinApplySchemeSaveValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("amount", ResManager.loadKDString((String)"\u201c\u7406\u8d22\u91d1\u989d\u201d", (String)"FinApplySchemeSaveValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("planrevenue", ResManager.loadKDString((String)"\u201c\u9884\u8ba1\u6536\u76ca\u7387\uff08%\uff09\u201d", (String)"FinApplySchemeSaveValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("basis", ResManager.loadKDString((String)"\u201c\u8ba1\u606f\u57fa\u51c6\u201d", (String)"FinApplySchemeSaveValidator_13", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("intdate", ResManager.loadKDString((String)"\u201c\u8d77\u606f\u65e5\u201d", (String)"FinApplySchemeSaveValidator_14", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("bonusway", ResManager.loadKDString((String)"\u201c\u5206\u7ea2\u65b9\u5f0f\u201d", (String)"FinApplySchemeSaveValidator_15", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("revenueproject", ResManager.loadKDString((String)"\u201c\u6536\u76ca\u65b9\u6848\u201d", (String)"FinApplySchemeSaveValidator_16", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("risklevel", ResManager.loadKDString((String)"\u201c\u98ce\u9669\u7b49\u7ea7\u201d", (String)"FinApplySchemeSaveValidator_17", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("revenuetype", ResManager.loadKDString((String)"\u201c\u6536\u76ca\u7c7b\u578b\u201d", (String)"FinApplySchemeSaveValidator_18", (String)"tmc-cim-business", (Object[])new Object[0]));
        return propMap;
    }

    private void validateAmountAndProduct(DynamicObject finApply, ExtendedDataEntity extendedDataEntity) {
        List errMsgs = SuperMarketHelper.getValidateProductCardMsgs((DynamicObject)finApply, (String)"");
        if (EmptyUtil.isNoEmpty((Object)errMsgs)) {
            for (String errMsg : errMsgs) {
                this.addErrorMessage(extendedDataEntity, errMsg);
            }
        }
    }
}

