/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.AgreeDepositStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class AgreeDepositUnCloseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("bankacct");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map<Long, List<Long>> idMap = this.dealCurrentBatchBills(dataEntity);
        Set<Long> existBankSet = this.getUsedBankAcctSet(dataEntity);
        for (ExtendedDataEntity extData : dataEntity) {
            Long bankAcctId;
            List<Long> doingAgreeIds;
            DynamicObject agreeDeposit = extData.getDataEntity();
            QFilter qFilter = new QFilter("srcdepositno", "=", (Object)agreeDeposit.getString("billno"));
            boolean exists = TmcDataServiceHelper.exists((String)"cim_agreement_deposit", (QFilter[])new QFilter[]{qFilter});
            if (exists) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6210\u65b0\u7684\u534f\u5b9a\u5b58\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5173\u95ed\u3002", (String)"AgreeDepositUnCloseValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (((doingAgreeIds = idMap.get(bankAcctId = Long.valueOf(agreeDeposit.getDynamicObject("bankacct").getLong("id")))).size() <= 1 || doingAgreeIds.indexOf(agreeDeposit.getLong("id")) <= 0) && !existBankSet.contains(bankAcctId)) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u534f\u5b9a\u8d26\u53f7\u7684\u534f\u5b9a\u5b58\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5173\u95ed\u3002", (String)"AgreeDepositUnCloseValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private Set<Long> getUsedBankAcctSet(ExtendedDataEntity[] dataEntity) {
        Set bankAcctSet = Arrays.stream(dataEntity).map(r -> r.getDataEntity()).map(r -> r.getDynamicObject("bankacct")).map(r -> r.getLong("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("status", "=", (Object)AgreeDepositStatusEnum.NORMAL.getValue()));
        qFilter.and(new QFilter("bankacct", "in", bankAcctSet));
        DynamicObjectCollection agreeBills = QueryServiceHelper.query((String)"cim_agreement_deposit", (String)"bankacct", (QFilter[])new QFilter[]{qFilter});
        return agreeBills.stream().map(r -> r.getLong("bankacct")).collect(Collectors.toSet());
    }

    private Map<Long, List<Long>> dealCurrentBatchBills(ExtendedDataEntity[] dataEntity) {
        HashMap<Long, List<Long>> idMap = new HashMap<Long, List<Long>>();
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject agreeBill = extData.getDataEntity();
            Long bankAcctId = agreeBill.getDynamicObject("bankacct").getLong("id");
            List curBillIds = idMap.computeIfAbsent(bankAcctId, k -> new ArrayList());
            curBillIds.add(agreeBill.getLong("id"));
        }
        return idMap;
    }
}

